/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.level;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XpRequirements {
    private final AuraSkillsPlugin plugin;
    private final List<Integer> defaultXpRequirements;
    private final Map<Skill, List<Integer>> skillXpRequirements;

    public XpRequirements(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.defaultXpRequirements = new ArrayList<Integer>();
        this.skillXpRequirements = new HashMap<Skill, List<Integer>>();
        this.addDefaultXpRequirements();
    }

    public void setSkillXpRequirements(Skill skill, List<Integer> xpRequirements) {
        this.skillXpRequirements.put(skill, xpRequirements);
    }

    public void removeSkillXpRequirements(Skill skill) {
        this.skillXpRequirements.remove(skill);
    }

    public void setDefaultXpRequirements(List<Integer> xpRequirements) {
        this.defaultXpRequirements.clear();
        this.defaultXpRequirements.addAll(xpRequirements);
    }

    public int getXpRequired(Skill skill, int level) {
        List<Integer> skillList = this.skillXpRequirements.get(skill);
        if (skillList != null) {
            if (skillList.size() > level - this.plugin.config().getStartLevel() - 1) {
                return skillList.get(level - this.plugin.config().getStartLevel() - 1);
            }
            return 0;
        }
        return this.getDefaultXpRequired(level);
    }

    public int getDefaultXpRequired(int level) {
        if (this.defaultXpRequirements.size() > level - this.plugin.config().getStartLevel() - 1) {
            return this.defaultXpRequirements.get(level - this.plugin.config().getStartLevel() - 1);
        }
        return 0;
    }

    public int getListSize(Skill skill) {
        List<Integer> skillList = this.skillXpRequirements.get(skill);
        if (skillList != null) {
            return skillList.size();
        }
        return this.defaultXpRequirements.size();
    }

    private void addDefaultXpRequirements() {
        this.defaultXpRequirements.clear();
        int highestMaxLevel = this.plugin.config().getHighestMaxLevel();
        for (int i = 0; i < highestMaxLevel - this.plugin.config().getStartLevel(); ++i) {
            this.defaultXpRequirements.add(100 * i * i + 100);
        }
    }
}

