/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.level;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityUtil;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.message.MessageBuilder;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.LevelerFormat;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.type.MoneyReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.math.RomanNumber;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;

public class LevelUpMessenger {
    private static final int WRAP_LENGTH = 40;
    private final AuraSkillsPlugin plugin;
    private final User user;
    private final Locale locale;
    private final Skill skill;
    private final int level;
    private final List<SkillReward> rewards;

    public LevelUpMessenger(AuraSkillsPlugin plugin, User user, Locale locale, Skill skill, int level, List<SkillReward> rewards) {
        this.plugin = plugin;
        this.user = user;
        this.locale = locale;
        this.skill = skill;
        this.level = level;
        this.rewards = rewards;
    }

    public void sendChatMessage() {
        MessageBuilder.create(this.plugin).locale(this.locale).message((MessageKey)LevelerFormat.CHAT, "skill", this.skill.getDisplayName(this.locale), "old", RomanNumber.toRoman(this.level - 1, this.plugin), "new", RomanNumber.toRoman(this.level, this.plugin), "stat_level", this.getRewardMessage(), "ability_unlock", this.getAbilityUnlockMessage(), "ability_level_up", this.getAbilityLevelUpMessage(), "mana_ability_unlock", this.getManaAbilityUnlockMessage(), "mana_ability_level_up", this.getManaAbilityLevelUpMessage(), "money_reward", this.getMoneyRewardMessage()).send(this.user);
    }

    public void sendTitle() {
        String title = MessageBuilder.create(this.plugin).locale(this.locale).rawMessage(LevelerFormat.TITLE, "skill", this.skill.getDisplayName(this.locale), "old", RomanNumber.toRoman(this.level - 1, this.plugin), "new", RomanNumber.toRoman(this.level, this.plugin)).toString();
        String subtitle = MessageBuilder.create(this.plugin).locale(this.locale).rawMessage(LevelerFormat.SUBTITLE, "skill", this.skill.getDisplayName(this.locale), "old", RomanNumber.toRoman(this.level - 1, this.plugin), "new", RomanNumber.toRoman(this.level, this.plugin)).toString();
        this.plugin.getUiProvider().sendTitle(this.user, title, subtitle, this.plugin.configInt(Option.LEVELER_TITLE_FADE_IN), this.plugin.configInt(Option.LEVELER_TITLE_STAY), this.plugin.configInt(Option.LEVELER_TITLE_FADE_OUT));
    }

    private String getRewardMessage() {
        StringBuilder rewardMessage = new StringBuilder();
        for (SkillReward reward : this.rewards) {
            rewardMessage.append(reward.getChatMessage(this.user, this.locale, this.skill, this.level));
        }
        return rewardMessage.toString();
    }

    private String getAbilityUnlockMessage() {
        MessageBuilder builder = MessageBuilder.create(this.plugin).locale(this.locale);
        for (Ability ability : this.plugin.getAbilityManager().getAbilities(this.skill, this.level)) {
            if (!ability.isEnabled() || ability.getUnlock() != this.level) continue;
            String desc = TextUtil.replace(this.plugin.getAbilityManager().getBaseDescription(ability, this.user, true), "{value}", AbilityUtil.getCurrentValue(ability, 1), "{value_2}", AbilityUtil.getCurrentValue2(ability, 1));
            desc = TextUtil.wrapText(desc, 40, "\n" + this.descWrap(this.locale));
            builder.message((MessageKey)LevelerFormat.ABILITY_UNLOCK, "ability", ability.getDisplayName(this.locale), "desc", desc);
        }
        return builder.toString();
    }

    private String getAbilityLevelUpMessage() {
        StringBuilder sb = new StringBuilder();
        for (Ability ability : this.plugin.getAbilityManager().getAbilities(this.skill, this.level)) {
            if (!ability.isEnabled() || ability.getUnlock() == this.level) continue;
            int level = this.user.getAbilityLevel(ability);
            sb.append(TextUtil.replace(this.plugin.getMsg(LevelerFormat.ABILITY_LEVEL_UP, this.locale), "{ability}", ability.getDisplayName(this.locale), "{previous}", RomanNumber.toRoman(level - 1, this.plugin), "{level}", RomanNumber.toRoman(level, this.plugin), "{desc}", this.getAbilityLevelUpDesc(ability, level, this.locale)));
        }
        return sb.toString();
    }

    private String getAbilityLevelUpDesc(Ability ability, int level, Locale locale) {
        String format = this.plugin.getMsg(LevelerFormat.DESC_UPGRADE_VALUE, locale);
        String desc = TextUtil.replace(this.plugin.getAbilityManager().getBaseDescription(ability, this.user, true), "{value}", AbilityUtil.getUpgradeValue(ability, level - 1, format), "{value_2}", AbilityUtil.getUpgradeValue2(ability, level - 1, format));
        desc = TextUtil.wrapText(desc, 40, "\n" + this.descWrap(locale));
        return desc;
    }

    private String getManaAbilityUnlockMessage() {
        StringBuilder sb = new StringBuilder();
        ManaAbility manaAbility = this.plugin.getManaAbilityManager().getManaAbilityAtLevel(this.skill, this.level);
        if (manaAbility == null) {
            return "";
        }
        if (!manaAbility.isEnabled()) {
            return "";
        }
        if (manaAbility.getUnlock() == this.level) {
            String desc = TextUtil.replace(this.plugin.getManaAbilityManager().getBaseDescription(manaAbility, this.user, false).replace("<1>", "<white>"), "{value}", String.valueOf(manaAbility.getDisplayValue(1)), "{haste_level}", String.valueOf(manaAbility.optionInt("haste_level", 10)), "{duration}", NumberUtil.format1(AbilityUtil.getDuration(manaAbility, 1)));
            desc = TextUtil.wrapText(desc, 40, "\n" + this.descWrap(this.locale));
            sb.append(TextUtil.replace(this.plugin.getMessageProvider().getRaw(LevelerFormat.MANA_ABILITY_UNLOCK, this.locale), "{mana_ability}", manaAbility.getDisplayName(this.locale), "{desc}", desc));
        }
        return this.plugin.getMessageProvider().applyFormatting(sb.toString());
    }

    private String getManaAbilityLevelUpMessage() {
        StringBuilder sb = new StringBuilder();
        ManaAbility manaAbility = this.plugin.getManaAbilityManager().getManaAbilityAtLevel(this.skill, this.level);
        if (manaAbility == null) {
            return "";
        }
        if (!manaAbility.isEnabled()) {
            return "";
        }
        if (manaAbility.getUnlock() != this.level) {
            int level = this.user.getManaAbilityLevel(manaAbility);
            sb.append(TextUtil.replace(this.plugin.getMessageProvider().getRaw(LevelerFormat.MANA_ABILITY_LEVEL_UP, this.locale), "{mana_ability}", manaAbility.getDisplayName(this.locale, false), "{previous}", RomanNumber.toRoman(level - 1, this.plugin), "{level}", RomanNumber.toRoman(level, this.plugin), "{desc}", this.getManaAbilityLevelUpDesc(manaAbility, level, this.locale)));
        }
        return this.plugin.getMessageProvider().applyFormatting(sb.toString());
    }

    private String getManaAbilityLevelUpDesc(ManaAbility manaAbility, int level, Locale locale) {
        String format = this.plugin.getMsg(LevelerFormat.DESC_UPGRADE_VALUE, locale);
        String message = TextUtil.replace(this.plugin.getManaAbilityManager().getBaseDescription(manaAbility, this.user, false).replace("<1>", "<white>"), "{value}", AbilityUtil.getUpgradeValue(manaAbility, level - 1, format), "{haste_level}", String.valueOf(manaAbility.optionInt("haste_level", 10)), "{duration}", AbilityUtil.getUpgradeDuration(manaAbility, level - 1, format));
        message = TextUtil.wrapText(message, 40, "\n" + this.descWrap(locale));
        return message;
    }

    private String getMoneyRewardMessage() {
        MessageBuilder builder = MessageBuilder.create(this.plugin).locale(this.locale);
        double totalMoney = 0.0;
        for (MoneyReward reward : this.plugin.getRewardManager().getRewardTable(this.skill).searchRewards(MoneyReward.class, this.level)) {
            totalMoney += reward.getAmount(this.level);
        }
        if (totalMoney > 0.0) {
            DecimalFormat nf = new DecimalFormat("#.##");
            builder.message((MessageKey)LevelerFormat.MONEY_REWARD, "amount", nf.format(totalMoney));
        }
        return builder.toString();
    }

    private String descWrap(Locale locale) {
        return this.plugin.getMsg(LevelerFormat.DESC_WRAP, locale);
    }
}

