/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.leaderboard;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.leaderboard.AverageSorter;
import dev.aurelium.auraskills.common.leaderboard.LeaderboardSorter;
import dev.aurelium.auraskills.common.leaderboard.SkillValue;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class LeaderboardManager {
    private final AuraSkillsPlugin plugin;
    private final Map<Skill, List<SkillValue>> skillLeaderboards;
    private List<SkillValue> powerLeaderboard;
    private List<SkillValue> averageLeaderboard;
    private volatile boolean sorting = false;

    public LeaderboardManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.skillLeaderboards = new HashMap<Skill, List<SkillValue>>();
        this.powerLeaderboard = new ArrayList<SkillValue>();
        this.averageLeaderboard = new ArrayList<SkillValue>();
    }

    public void startLeaderboardUpdater() {
        this.plugin.getScheduler().timerAsync(new TaskRunnable(){

            @Override
            public void run() {
                LeaderboardManager.this.updateLeaderboardsSync();
            }
        }, 300L, 300L, TimeUnit.SECONDS);
    }

    public void updateLeaderboards() {
        this.updateLeaderboardsSync();
    }

    private void updateLeaderboardsSync() {
        if (this.sorting) {
            return;
        }
        try {
            this.setSorting(true);
            HashMap<Skill, List<SkillValue>> skillLeaderboards = new HashMap<Skill, List<SkillValue>>();
            for (Skill skill : this.plugin.getSkillRegistry().getValues()) {
                skillLeaderboards.put(skill, new ArrayList());
            }
            ArrayList<SkillValue> powerLeaderboard = new ArrayList<SkillValue>();
            ArrayList<SkillValue> averageLeaderboard = new ArrayList<SkillValue>();
            this.addLoadedPlayersToLeaderboards(skillLeaderboards, powerLeaderboard, averageLeaderboard);
            this.addOfflinePlayers(skillLeaderboards, powerLeaderboard, averageLeaderboard);
            this.sortLeaderboards(skillLeaderboards, powerLeaderboard, averageLeaderboard);
            this.setSorting(false);
        }
        catch (Exception e) {
            this.plugin.logger().warn("Error updating leaderboards: " + e.getMessage());
            e.printStackTrace();
            this.setSorting(false);
        }
    }

    public List<SkillValue> getLeaderboard(Skill skill) {
        return this.skillLeaderboards.computeIfAbsent(skill, s -> new ArrayList());
    }

    public void setLeaderboard(Skill skill, List<SkillValue> leaderboard) {
        this.skillLeaderboards.put(skill, leaderboard);
    }

    public List<SkillValue> getLeaderboard(Skill skill, int page, int numPerPage) {
        List leaderboard = this.skillLeaderboards.computeIfAbsent(skill, k -> new ArrayList());
        int from = (Math.max(page, 1) - 1) * numPerPage;
        int to = from + numPerPage;
        return leaderboard.subList(Math.min(from, leaderboard.size()), Math.min(to, leaderboard.size()));
    }

    @Nullable
    public SkillValue getSkillValue(Skill skill, int place) {
        List<SkillValue> values = this.getLeaderboard(skill, place, 1);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public List<SkillValue> getPowerLeaderboard() {
        return this.powerLeaderboard;
    }

    public List<SkillValue> getPowerLeaderboard(int page, int numPerPage) {
        int from = (Math.max(page, 1) - 1) * numPerPage;
        int to = from + numPerPage;
        return this.powerLeaderboard.subList(Math.min(from, this.powerLeaderboard.size()), Math.min(to, this.powerLeaderboard.size()));
    }

    public void setPowerLeaderboard(List<SkillValue> leaderboard) {
        this.powerLeaderboard = leaderboard;
    }

    public List<SkillValue> getAverageLeaderboard() {
        return this.averageLeaderboard;
    }

    public List<SkillValue> getAverageLeaderboard(int page, int numPerPage) {
        int from = (Math.max(page, 1) - 1) * numPerPage;
        int to = from + numPerPage;
        return this.averageLeaderboard.subList(Math.min(from, this.averageLeaderboard.size()), Math.min(to, this.averageLeaderboard.size()));
    }

    public void setAverageLeaderboard(List<SkillValue> leaderboard) {
        this.averageLeaderboard = leaderboard;
    }

    public int getSkillRank(Skill skill, UUID id) {
        List<SkillValue> leaderboard = this.skillLeaderboards.get(skill);
        if (leaderboard == null) {
            return 0;
        }
        for (SkillValue skillValue : leaderboard) {
            if (!skillValue.id().equals(id)) continue;
            return leaderboard.indexOf(skillValue) + 1;
        }
        return 0;
    }

    public int getPowerRank(UUID id) {
        for (SkillValue skillValue : this.powerLeaderboard) {
            if (!skillValue.id().equals(id)) continue;
            return this.powerLeaderboard.indexOf(skillValue) + 1;
        }
        return 0;
    }

    public int getAverageRank(UUID id) {
        for (SkillValue skillValue : this.averageLeaderboard) {
            if (!skillValue.id().equals(id)) continue;
            return this.averageLeaderboard.indexOf(skillValue) + 1;
        }
        return 0;
    }

    public boolean isNotSorting() {
        return !this.sorting;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
    }

    private void addLoadedPlayersToLeaderboards(Map<Skill, List<SkillValue>> skillLb, List<SkillValue> powerLb, List<SkillValue> averageLb) {
        for (User user : this.plugin.getUserManager().getUserMap().values()) {
            UUID id = user.getUuid();
            int powerLevel = 0;
            double powerXp = 0.0;
            int numEnabled = 0;
            for (Skills skill : Skills.values()) {
                int level = user.getSkillLevel(skill);
                double xp = user.getSkillXp(skill);
                SkillValue skillLevel = new SkillValue(id, level, xp);
                skillLb.get(skill).add(skillLevel);
                if (!skill.isEnabled()) continue;
                powerLevel += level;
                powerXp += xp;
                ++numEnabled;
            }
            SkillValue powerValue = new SkillValue(id, powerLevel, powerXp);
            powerLb.add(powerValue);
            double averageLevel = (double)powerLevel / (double)numEnabled;
            SkillValue averageValue = new SkillValue(id, 0, averageLevel);
            averageLb.add(averageValue);
        }
    }

    private void addOfflinePlayers(Map<Skill, List<SkillValue>> skillLb, List<SkillValue> powerLb, List<SkillValue> averageLb) throws Exception {
        List<UserState> offlineStates = this.plugin.getStorageProvider().loadStates(true);
        for (UserState state : offlineStates) {
            int powerLevel = 0;
            double powerXp = 0.0;
            int numEnabled = 0;
            for (Skill skill : state.skillLevels().keySet()) {
                int level = state.skillLevels().get(skill);
                double xp = state.skillXp().get(skill);
                SkillValue skillValue = new SkillValue(state.uuid(), level, xp);
                skillLb.get(skill).add(skillValue);
                if (!skill.isEnabled()) continue;
                powerLevel += level;
                powerXp += xp;
                ++numEnabled;
            }
            powerLb.add(new SkillValue(state.uuid(), powerLevel, powerXp));
            double averageLevel = (double)powerLevel / (double)numEnabled;
            averageLb.add(new SkillValue(state.uuid(), 0, averageLevel));
        }
    }

    private void sortLeaderboards(Map<Skill, List<SkillValue>> skillLb, List<SkillValue> powerLb, List<SkillValue> averageLb) {
        LeaderboardSorter sorter = new LeaderboardSorter();
        for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
            skillLb.get(skill).sort(sorter);
        }
        powerLb.sort(sorter);
        AverageSorter averageSorter = new AverageSorter();
        averageLb.sort(averageSorter);
        for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
            this.setLeaderboard(skill, skillLb.get(skill));
        }
        this.setPowerLeaderboard(powerLb);
        this.setAverageLeaderboard(averageLb);
    }
}

