/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.config;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigurateLoader {
    private final AuraSkillsPlugin plugin;
    private final ClassLoader classLoader;
    private final TypeSerializerCollection serializers;

    public ConfigurateLoader(AuraSkillsPlugin plugin, TypeSerializerCollection serializers) {
        this.plugin = plugin;
        this.classLoader = plugin.getClass().getClassLoader();
        this.serializers = serializers == null ? TypeSerializerCollection.builder().build() : serializers;
    }

    public ConfigurationNode loadEmbeddedFile(String fileName) throws IOException {
        ConfigurationNode config = this.loadEmbeddedFileOrNull(fileName);
        if (config == null) {
            throw new IllegalArgumentException("File " + fileName + "does not exist");
        }
        return config;
    }

    @Nullable
    public ConfigurationNode loadEmbeddedFileOrNull(String fileName) throws IOException {
        URI uri = this.getEmbeddedURI(fileName);
        if (uri == null) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem ignored = FileSystems.newFileSystem(uri, env);){
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Path.of(uri))).defaultOptions(opts -> opts.serializers(build -> build.registerAll(this.serializers)))).build();
            Object n = loader.load();
            return n;
        }
    }

    public ConfigurationNode loadUserFile(String path) throws IOException {
        File file = new File(this.plugin.getPluginFolder(), path);
        if (!file.exists()) {
            throw new RuntimeException("File does not exist!");
        }
        return this.loadUserFile(file);
    }

    public ConfigurationNode loadUserFile(File file) throws IOException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath())).defaultOptions(opts -> opts.serializers(build -> build.registerAll(this.serializers)))).build();
        return loader.load();
    }

    public void updateUserFile(String path) throws IOException {
        ConfigurationNode embedded = this.loadEmbeddedFile(path);
        File userFile = new File(this.plugin.getPluginFolder(), path);
        ConfigurationNode user = this.loadUserFile(userFile);
        int embeddedVer = embedded.node("file_version").getInt(-1);
        int userVer = user.node("file_version").getInt(0);
        if (embeddedVer == -1) {
            throw new IllegalStateException("Embedded file does not have a file_version");
        }
        if (embeddedVer > userVer) {
            ConfigurationNode merged = this.mergeNodes(embedded, user);
            merged.node("file_version").set(embeddedVer);
            this.saveConfigIfUpdated(userFile, embedded, user, merged);
        }
    }

    public void saveConfigIfUpdated(File file, ConfigurationNode embedded, ConfigurationNode user, ConfigurationNode merged) throws IOException {
        int userCount;
        int embeddedCount = this.countChildren(embedded);
        if (embeddedCount > (userCount = this.countChildren(user))) {
            FileUtil.saveYamlFile(file, merged);
            String path = this.plugin.getPluginFolder().toPath().relativize(file.toPath()).toString();
            int updated = embeddedCount - userCount;
            this.plugin.logger().info("Updated " + path + " with " + updated + " new key" + (updated != 1 ? "s" : ""));
        }
    }

    public int countChildren(ConfigurationNode root) {
        int count = 0;
        Stack<ConfigurationNode> stack = new Stack<ConfigurationNode>();
        stack.addAll(root.childrenMap().values());
        while (!stack.isEmpty()) {
            ConfigurationNode node = (ConfigurationNode)stack.pop();
            if (node.isMap()) {
                stack.addAll(node.childrenMap().values());
                continue;
            }
            ++count;
        }
        return count;
    }

    public void generateUserFile(String path) {
        try {
            ConfigurationNode config = this.loadEmbeddedFileOrNull(path);
            if (config == null) {
                return;
            }
            File file = new File(this.plugin.getPluginFolder(), path);
            if (!file.exists()) {
                FileUtil.saveYamlFile(file, config);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigurationNode mergeNodes(ConfigurationNode ... nodes) throws SerializationException {
        if (nodes.length == 0) {
            throw new IllegalArgumentException("Must provide at least one node");
        }
        ConfigurationNode merged = nodes[0].copy();
        for (int i = 1; i < nodes.length; ++i) {
            ConfigurationNode node = nodes[i];
            if (node == null) continue;
            this.mergeRec(merged, node);
        }
        return merged;
    }

    private void mergeRec(ConfigurationNode base, ConfigurationNode source) throws SerializationException {
        for (ConfigurationNode configurationNode : source.childrenMap().values()) {
            if (configurationNode.isMap()) {
                this.mergeRec(base.node(configurationNode.key()), configurationNode);
                continue;
            }
            base.node(configurationNode.key()).set(configurationNode.raw());
        }
    }

    public ConfigurationNode loadContentAndMerge(@Nullable ConfigurationNode base, String path, ConfigurationNode ... others) throws SerializationException {
        ArrayList<ConfigurationNode> loadedFiles = new ArrayList<ConfigurationNode>();
        if (base != null) {
            loadedFiles.add(base);
        }
        for (File dir : this.plugin.getSkillManager().getContentDirectories()) {
            File file = new File(dir, path);
            try {
                ConfigurationNode config = this.loadUserFile(file);
                loadedFiles.add(config);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to load file " + file.getName() + " in content directory " + dir.getPath());
                e.printStackTrace();
            }
        }
        loadedFiles.addAll(Arrays.asList(others));
        return this.mergeNodes(loadedFiles.toArray(new ConfigurationNode[0]));
    }

    private URI getEmbeddedURI(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        try {
            URL url = this.classLoader.getResource(fileName);
            if (url == null) {
                return null;
            }
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

