/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.api.implementation;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.user.SkillsUser;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class ApiSkillsUser
implements SkillsUser {
    private final User user;
    private final AuraSkillsPlugin plugin;

    public ApiSkillsUser(User user) {
        this.user = user;
        this.plugin = user.getPlugin();
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public UUID getUuid() {
        return this.user.getUuid();
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public double getSkillXp(Skill skill) {
        return this.user.getSkillXp(skill);
    }

    @Override
    public void addSkillXp(Skill skill, double amountToAdd) {
        this.plugin.getLevelManager().addXp(this.user, skill, null, amountToAdd);
    }

    @Override
    public void addSkillXp(Skill skill, double amountToAdd, XpSource source) {
        this.plugin.getLevelManager().addXp(this.user, skill, source, amountToAdd);
    }

    @Override
    public void addSkillXpRaw(Skill skill, double amountToAdd) {
        this.user.addSkillXp(skill, amountToAdd);
        this.plugin.getLevelManager().checkLevelUp(this.user, skill);
    }

    @Override
    public void setSkillXp(Skill skill, double amount) {
        this.user.setSkillXp(skill, amount);
        this.plugin.getLevelManager().checkLevelUp(this.user, skill);
    }

    @Override
    public int getSkillLevel(Skill skill) {
        return this.user.getSkillLevel(skill);
    }

    @Override
    public void setSkillLevel(Skill skill, int level) {
        this.user.setSkillLevel(skill, level);
    }

    @Override
    public double getSkillAverage() {
        return this.user.getSkillAverage();
    }

    @Override
    public double getStatLevel(Stat stat) {
        return this.user.getStatLevel(stat);
    }

    @Override
    public double getBaseStatLevel(Stat stat) {
        return this.user.getBaseStatLevel(stat);
    }

    @Override
    public double getMana() {
        return this.user.getMana();
    }

    @Override
    public double getMaxMana() {
        return this.user.getMaxMana();
    }

    @Override
    public void setMana(double mana) {
        this.user.setMana(mana);
    }

    @Override
    public boolean consumeMana(double amount) {
        if (this.user.getMana() >= amount) {
            this.user.setMana(this.user.getMana() - amount);
            return true;
        }
        this.plugin.getManaAbilityManager().sendNotEnoughManaMessage(this.user, amount);
        return false;
    }

    @Override
    public int getPowerLevel() {
        return this.user.getPowerLevel();
    }

    @Override
    public void addStatModifier(StatModifier statModifier) {
        this.user.addStatModifier(statModifier);
    }

    @Override
    public void removeStatModifier(String name) {
        this.user.removeStatModifier(name);
    }

    @Override
    @Nullable
    public StatModifier getStatModifier(String name) {
        return this.user.getStatModifier(name);
    }

    @Override
    public Map<String, StatModifier> getStatModifiers() {
        return this.user.getStatModifiers();
    }

    @Override
    public void addTraitModifier(TraitModifier traitModifier) {
        this.user.addTraitModifier(traitModifier);
    }

    @Override
    public void removeTraitModifier(String name) {
        this.user.removeTraitModifier(name);
    }

    @Override
    @Nullable
    public TraitModifier getTraitModifier(String name) {
        return this.user.getTraitModifier(name);
    }

    @Override
    public Map<String, TraitModifier> getTraitModifiers() {
        return this.user.getTraitModifiers();
    }

    @Override
    public double getEffectiveTraitLevel(Trait trait) {
        return this.user.getEffectiveTraitLevel(trait);
    }

    @Override
    public double getBonusTraitLevel(Trait trait) {
        return this.user.getBonusTraitLevel(trait);
    }

    @Override
    public int getAbilityLevel(Ability ability) {
        return this.user.getAbilityLevel(ability);
    }

    @Override
    public int getManaAbilityLevel(ManaAbility manaAbility) {
        return this.user.getManaAbilityLevel(manaAbility);
    }

    @Override
    public Locale getLocale() {
        return this.user.getLocale();
    }

    @Override
    public boolean hasSkillPermission(Skill skill) {
        return this.user.hasSkillPermission(skill);
    }

    @Override
    public Set<Skill> getJobs() {
        return this.user.getJobs();
    }

    @Override
    public void addJob(Skill job) {
        this.user.addJob(job);
    }

    @Override
    public void removeJob(Skill job) {
        this.user.removeJob(job);
    }

    @Override
    public void clearAllJobs() {
        this.user.clearAllJobs();
    }

    @Override
    public int getJobLimit() {
        return this.user.getJobLimit();
    }
}

