/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.api.implementation;

import dev.aurelium.auraskills.api.ability.CustomAbility;
import dev.aurelium.auraskills.api.mana.CustomManaAbility;
import dev.aurelium.auraskills.api.registry.NamespaceIdentified;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.source.XpSourceParser;
import dev.aurelium.auraskills.api.stat.CustomStat;
import dev.aurelium.auraskills.api.trait.CustomTrait;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.api.implementation.ApiSourceType;
import java.io.File;
import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiNamespacedRegistry
implements NamespacedRegistry {
    private final String namespace;
    private final AuraSkillsPlugin plugin;
    private File contentDirectory;
    @Nullable
    private File menuDirectory;
    @Nullable
    private File lootDirectory;

    public ApiNamespacedRegistry(AuraSkillsPlugin plugin, String namespace, File contentDirectory) {
        this.plugin = plugin;
        this.namespace = namespace;
        this.contentDirectory = contentDirectory;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void registerSkill(CustomSkill skill) {
        this.validateNamespace(skill);
        this.plugin.getSkillRegistry().register(skill.getId(), skill, this.plugin.getSkillManager().getSupplier());
    }

    @Override
    public void registerAbility(CustomAbility ability) {
        this.validateNamespace(ability);
        this.plugin.getAbilityRegistry().register(ability.getId(), ability, this.plugin.getAbilityManager().getSupplier());
    }

    @Override
    public void registerManaAbility(CustomManaAbility manaAbility) {
        this.validateNamespace(manaAbility);
        this.plugin.getManaAbilityRegistry().register(manaAbility.getId(), manaAbility, this.plugin.getManaAbilityManager().getSupplier());
    }

    @Override
    public void registerStat(CustomStat stat) {
        this.validateNamespace(stat);
        this.plugin.getStatRegistry().register(stat.getId(), stat, this.plugin.getStatManager().getSupplier());
    }

    @Override
    public void registerTrait(CustomTrait trait) {
        this.validateNamespace(trait);
        this.plugin.getTraitRegistry().register(trait.getId(), trait, this.plugin.getTraitManager().getSupplier());
    }

    @Override
    public SourceType registerSourceType(String name, XpSourceParser<?> parser) {
        NamespacedId id = NamespacedId.of(this.namespace, name.toLowerCase(Locale.ROOT));
        ApiSourceType sourceType = new ApiSourceType(this.plugin, id, parser);
        this.plugin.getSourceTypeRegistry().register(id, sourceType);
        return sourceType;
    }

    @Override
    public File getContentDirectory() {
        return this.contentDirectory;
    }

    @Override
    public void setContentDirectory(File contentDirectory) {
        this.contentDirectory = contentDirectory;
    }

    @Override
    @NotNull
    public Optional<File> getMenuDirectory() {
        return Optional.ofNullable(this.menuDirectory);
    }

    @Override
    public void setMenuDirectory(@Nullable File menuDirectory) {
        this.menuDirectory = menuDirectory;
    }

    @Override
    @NotNull
    public Optional<File> getLootDirectory() {
        return Optional.ofNullable(this.lootDirectory);
    }

    @Override
    public void setLootDirectory(@Nullable File lootDirectory) {
        this.lootDirectory = lootDirectory;
    }

    private void validateNamespace(NamespaceIdentified identified) {
        if (!identified.getId().getNamespace().equals(this.namespace)) {
            throw new IllegalArgumentException("The namespace of NamespacedId " + identified.getId() + " must match the registry namespace " + this.namespace);
        }
    }
}

