/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.ability;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbilityProvider;
import dev.aurelium.auraskills.api.ability.CustomAbility;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.registry.Registry;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class AbilityRegistry
extends Registry<Ability, AbilityProvider> {
    public AbilityRegistry(AuraSkillsPlugin plugin) {
        super(plugin, Ability.class, AbilityProvider.class);
        this.registerDefaults();
    }

    @Override
    public void registerDefaults() {
        for (Abilities ability : Abilities.values()) {
            this.register(ability.getId(), ability, this.plugin.getAbilityManager().getSupplier());
        }
    }

    public ConfigurationNode getDefinedConfig() throws SerializationException {
        CommentedConfigurationNode root = CommentedConfigurationNode.root();
        for (Ability ability : this.getValues()) {
            if (!(ability instanceof CustomAbility)) continue;
            CustomAbility customAbility = (CustomAbility)ability;
            ConfigurationNode abilityNode = root.node("abilities", ability.getId().toString());
            abilityNode.node("enabled").set(true);
            CustomAbility.Defined defined = customAbility.getDefined();
            abilityNode.node("base_value").set(defined.getBaseValue());
            abilityNode.node("value_per_level").set(defined.getValuePerLevel());
            abilityNode.node("unlock").set(defined.getUnlock());
            abilityNode.node("level_up").set(defined.getLevelUp());
            abilityNode.node("max_level").set(defined.getMaxLevel());
        }
        return root;
    }
}

