/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final Plugin plugin;
    private final int resourceId;

    public UpdateChecker(Plugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    consumer.accept(scanner.nextLine());
                }
            }
            catch (IOException exception) {
                this.plugin.getLogger().info("Cannot look for updates: " + exception.getMessage());
            }
        });
    }

    public boolean isOutdated(String localVersion, String resourceVersion) {
        int resourceIndex;
        if (localVersion.equalsIgnoreCase(resourceVersion)) {
            return false;
        }
        if (localVersion.contains("Pre-Release") || localVersion.contains("Build") || localVersion.contains("pre") || localVersion.contains("SNAPSHOT")) {
            return false;
        }
        String[] localSplit = localVersion.split(" ");
        String[] resourceSplit = resourceVersion.split(" ");
        String localNum = localSplit.length >= 2 && resourceSplit.length >= 2 ? localSplit[1] : localSplit[0];
        String resourceNum = resourceSplit.length >= 2 ? resourceSplit[1] : resourceSplit[0];
        int localIndex = localNum.indexOf("-");
        if (localIndex != -1) {
            localNum = localNum.substring(0, localIndex);
        }
        if ((resourceIndex = resourceNum.indexOf("-")) != -1) {
            resourceNum = resourceNum.substring(0, resourceIndex);
        }
        String[] localVersionSplit = localNum.split("\\.");
        String[] resourceVersionSplit = resourceNum.split("\\.");
        for (int i = 0; i < localVersionSplit.length && i < resourceVersionSplit.length; ++i) {
            try {
                int local = Integer.parseInt(localVersionSplit[i]);
                int resource = Integer.parseInt(resourceVersionSplit[i]);
                if (local < resource) {
                    return true;
                }
                if (local <= resource) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }
}

