/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import dev.aurelium.auraskills.common.util.PlatformUtil;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.kyori.adventure.text.minimessage.MiniMessage;
import dev.aurelium.auraskills.kyori.adventure.text.minimessage.ParsingException;
import dev.aurelium.auraskills.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class BukkitPlatformUtil
implements PlatformUtil {
    @Override
    public boolean isValidMaterial(String input) {
        Material material = this.parseMaterial(input.toUpperCase(Locale.ROOT));
        return material != null;
    }

    @Override
    public boolean isValidEntityType(String input) {
        input = this.convertEntityName(input).toUpperCase(Locale.ROOT);
        try {
            EntityType.valueOf((String)input);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public String convertEntityName(String input) {
        return switch (input) {
            case "snow_golem" -> "snowman";
            case "mooshroom" -> "mushroom_cow";
            default -> input;
        };
    }

    @Override
    public Component toComponent(String message) {
        message = TextUtil.replace(message, "\u00a7", "&");
        MiniMessage mm = MiniMessage.miniMessage();
        try {
            return mm.deserialize(message);
        }
        catch (ParsingException e) {
            Bukkit.getLogger().info("[Slate] Error applying MiniMessage formatting to input message: " + message);
            e.printStackTrace();
            return Component.text(message);
        }
    }

    @Override
    public String toString(Component component) {
        String message = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build().serialize(component);
        message = TextUtil.replaceNonEscaped(message, "&", "\u00a7");
        return message;
    }

    @Nullable
    private Material parseMaterial(String name) {
        return Material.getMaterial((String)name);
    }
}

