/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.user;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.skill.LoadedSkill;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitUserManager
implements UserManager {
    private final AuraSkills plugin;
    private final Map<UUID, User> playerDataMap = new ConcurrentHashMap<UUID, User>();

    public BukkitUserManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public User getUser(Player player) {
        User user = this.playerDataMap.get(player.getUniqueId());
        if (user != null) {
            return user;
        }
        return this.createNewUser(player.getUniqueId());
    }

    @Override
    @Nullable
    public User getUser(UUID uuid) {
        return this.playerDataMap.get(uuid);
    }

    @Override
    public void addUser(User user) {
        this.playerDataMap.put(user.getUuid(), user);
    }

    @Override
    public void removeUser(UUID uuid) {
        this.playerDataMap.remove(uuid);
    }

    @Override
    public boolean hasUser(UUID uuid) {
        return this.playerDataMap.containsKey(uuid);
    }

    @Override
    public Map<UUID, User> getUserMap() {
        return this.playerDataMap;
    }

    @Override
    public User createNewUser(UUID uuid) {
        @Nullable Player player = this.plugin.getServer().getPlayer(uuid);
        BukkitUser user = new BukkitUser(uuid, player, this.plugin);
        for (LoadedSkill loadedSkill : this.plugin.getSkillManager().getSkills()) {
            user.setSkillLevel(loadedSkill.skill(), this.plugin.config().getStartLevel());
            user.setSkillXp(loadedSkill.skill(), 0.0);
        }
        return user;
    }

    @Override
    public Set<User> getOnlineUsers() {
        HashSet<User> online = new HashSet<User>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.playerDataMap.containsKey(player.getUniqueId())) continue;
            online.add(this.playerDataMap.get(player.getUniqueId()));
        }
        return online;
    }
}

