/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.ui;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.ProtocolLibHook;
import dev.aurelium.auraskills.bukkit.ui.BossBarManager;
import dev.aurelium.auraskills.bukkit.ui.BukkitActionBarManager;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.ui.ActionBarManager;
import dev.aurelium.auraskills.common.ui.UiProvider;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.kyori.adventure.title.Title;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import java.text.NumberFormat;
import java.time.Duration;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BukkitUiProvider
implements UiProvider {
    private final AuraSkills plugin;
    private final ActionBarManager actionBarManager;
    private final BossBarManager bossBarManager;
    private final TextFormatter tf = new TextFormatter();

    public BukkitUiProvider(AuraSkills plugin) {
        this.plugin = plugin;
        this.actionBarManager = new BukkitActionBarManager(plugin, this);
        this.bossBarManager = new BossBarManager(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this.bossBarManager, (Plugin)plugin);
    }

    @Override
    public ActionBarManager getActionBarManager() {
        return this.actionBarManager;
    }

    @Override
    public NumberFormat getFormat(UiProvider.FormatType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case UiProvider.FormatType.XP -> this.bossBarManager.getXpFormat();
            case UiProvider.FormatType.PERCENT -> this.bossBarManager.getPercentFormat();
            case UiProvider.FormatType.MONEY -> this.bossBarManager.getMoneyFormat();
        };
    }

    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    @Override
    public void sendActionBar(User user, String message) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.getHookManager().isRegistered(ProtocolLibHook.class)) {
            ProtocolLibHook hook = this.plugin.getHookManager().getHook(ProtocolLibHook.class);
            hook.sendActionBar(player, message);
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
    }

    @Override
    public void sendXpBossBar(User user, Skill skill, double currentXp, double levelXp, double xpGained, int level, boolean maxed, double income) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return;
        }
        this.bossBarManager.sendBossBar(player, skill, currentXp, levelXp, xpGained, level, maxed, income);
    }

    @Override
    public void sendTitle(User user, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Player player = BukkitUser.getPlayer(user.toApi());
        if (player == null) {
            return;
        }
        Component cTitle = this.tf.toComponent(title);
        Component cSubtitle = this.tf.toComponent(subtitle);
        int fadeInMs = fadeIn * 50;
        int stayMs = stay * 50;
        int fadeOutMs = fadeOut * 50;
        this.plugin.getAudiences().player(player).showTitle(Title.title(cTitle, cSubtitle, Title.Times.times(Duration.ofMillis(fadeInMs), Duration.ofMillis(stayMs), Duration.ofMillis(fadeOutMs))));
    }
}

