/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.ui;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.message.BukkitMessageProvider;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.hooks.PlaceholderHook;
import dev.aurelium.auraskills.common.message.type.ActionBarMessage;
import dev.aurelium.auraskills.common.util.math.BigNumber;
import dev.aurelium.auraskills.common.util.math.RomanNumber;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.kyori.adventure.audience.Audience;
import dev.aurelium.auraskills.kyori.adventure.bossbar.BossBar;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class BossBarManager
implements Listener {
    private final Map<UUID, Map<Skill, BossBar>> bossBars;
    private final Map<UUID, Map<Skill, Integer>> currentActions;
    private final Map<UUID, Map<Skill, Integer>> checkCurrentActions;
    private final Map<UUID, BossBar> singleBossBars;
    private final Map<UUID, Integer> singleCurrentActions;
    private final Map<UUID, Integer> singleCheckCurrentActions;
    private String mode;
    private int stayTime;
    private Map<Skill, BossBar.Color> colors;
    private Map<Skill, BossBar.Overlay> overlays;
    private NumberFormat xpFormat;
    private NumberFormat percentFormat;
    private NumberFormat moneyFormat;
    private final AuraSkills plugin;
    private final TextFormatter tf = new TextFormatter();

    public BossBarManager(AuraSkills plugin) {
        this.bossBars = new HashMap<UUID, Map<Skill, BossBar>>();
        this.currentActions = new HashMap<UUID, Map<Skill, Integer>>();
        this.plugin = plugin;
        this.singleBossBars = new HashMap<UUID, BossBar>();
        this.singleCurrentActions = new HashMap<UUID, Integer>();
        this.checkCurrentActions = new HashMap<UUID, Map<Skill, Integer>>();
        this.singleCheckCurrentActions = new HashMap<UUID, Integer>();
        this.loadNumberFormats();
    }

    public NumberFormat getXpFormat() {
        return this.xpFormat;
    }

    public NumberFormat getPercentFormat() {
        return this.percentFormat;
    }

    public NumberFormat getMoneyFormat() {
        return this.moneyFormat;
    }

    private void loadNumberFormats() {
        try {
            this.xpFormat = new DecimalFormat(this.plugin.configString(Option.BOSS_BAR_XP_FORMAT));
            this.percentFormat = new DecimalFormat(this.plugin.configString(Option.BOSS_BAR_PERCENT_FORMAT));
            this.moneyFormat = new DecimalFormat(this.plugin.configString(Option.BOSS_BAR_MONEY_FORMAT));
        }
        catch (IllegalArgumentException e) {
            this.xpFormat = new DecimalFormat("#.#");
            this.percentFormat = new DecimalFormat("#.##");
            this.moneyFormat = new DecimalFormat("#.00");
            this.plugin.logger().warn("Invalid boss_bar.xp_format or percent_format: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadOptions() {
        this.loadNumberFormats();
        this.mode = this.plugin.configString(Option.BOSS_BAR_MODE);
        this.stayTime = this.plugin.configInt(Option.BOSS_BAR_STAY_TIME);
        this.colors = new HashMap<Skill, BossBar.Color>();
        this.overlays = new HashMap<Skill, BossBar.Overlay>();
        for (String entry : this.plugin.configStringList(Option.BOSS_BAR_FORMAT)) {
            void var5_5;
            Skill skill;
            String[] splitEntry = entry.split(" ");
            BossBar.Color color = BossBar.Color.GREEN;
            BossBar.Overlay overlay = BossBar.Overlay.PROGRESS;
            try {
                skill = (Skill)this.plugin.getSkillRegistry().get(NamespacedId.fromDefault(splitEntry[0].toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger().warn("Error loading boss bar format in config.yml: " + splitEntry[0] + " is not a valid Skill");
                skill = Skills.FARMING;
            }
            if (splitEntry.length > 1) {
                try {
                    BossBar.Color color2 = BossBar.Color.valueOf(splitEntry[1].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.logger().warn("Error loading boss bar format in config.yml: " + splitEntry[1] + " is not a valid BarColor");
                }
                if (splitEntry.length > 2) {
                    try {
                        overlay = BossBar.Overlay.valueOf(splitEntry[2].toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.logger().warn("Error loading boss bar format in config.yml: " + splitEntry[2] + " is not a valid BarStyle");
                    }
                }
            }
            this.colors.put(skill, (BossBar.Color)var5_5);
            this.overlays.put(skill, overlay);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Audience audience = this.plugin.getAudiences().player(player);
            for (Map.Entry<UUID, BossBar> entry : this.singleBossBars.entrySet()) {
                audience.hideBossBar(entry.getValue());
            }
            for (Map.Entry<UUID, Object> entry : this.bossBars.entrySet()) {
                Map bossBars = (Map)entry.getValue();
                for (Map.Entry bossBarEntry : bossBars.entrySet()) {
                    audience.hideBossBar((BossBar)bossBarEntry.getValue());
                }
            }
        }
        this.bossBars.clear();
        this.singleBossBars.clear();
    }

    public void sendBossBar(Player player, Skill skill, double currentXp, double levelXp, double xpGained, int level, boolean maxed, double income) {
        BossBar bossBar;
        UUID playerId = player.getUniqueId();
        if (maxed && !this.plugin.configBoolean(Option.BOSS_BAR_DISPLAY_MAXED)) {
            return;
        }
        this.incrementAction(player, skill);
        int currentAction = this.getCurrentAction(player, skill);
        if (currentAction == -1 || currentAction % this.plugin.configInt(Option.BOSS_BAR_UPDATE_EVERY) != 0) {
            return;
        }
        if (this.mode.equals("single")) {
            bossBar = this.singleBossBars.get(playerId);
        } else {
            if (!this.bossBars.containsKey(playerId)) {
                this.bossBars.put(playerId, new HashMap());
            }
            bossBar = this.bossBars.get(playerId).get(skill);
        }
        String text = this.getBossBarText(player, skill, currentXp, (long)levelXp, xpGained, level, maxed, income, this.plugin.getLocale((CommandSender)player));
        if (bossBar == null) {
            bossBar = this.handleNewBossBar(player, skill, currentXp, levelXp, text);
        } else {
            this.handleExistingBossBar(bossBar, player, skill, currentXp, levelXp, text);
        }
        if (this.mode.equals("single")) {
            this.singleCurrentActions.compute(playerId, (id, num) -> num == null ? 0 : num + 1);
        } else {
            this.currentActions.computeIfAbsent(playerId, k -> new HashMap()).compute(skill, (sk, num) -> num == null ? 0 : num + 1);
        }
        this.scheduleHide(playerId, skill, bossBar);
    }

    private BossBar handleNewBossBar(Player player, Skill skill, double currentXp, double levelXp, String text) {
        BossBar.Color color = this.getColor(skill);
        BossBar.Overlay overlay = this.getOverlay(skill);
        Component name = this.tf.toComponent(text);
        double progress = currentXp / levelXp;
        if (progress > 1.0 || progress < 0.0) {
            progress = 1.0;
        }
        BossBar bossBar = BossBar.bossBar(name, (float)progress, color, overlay);
        this.plugin.getAudiences().player(player).showBossBar(bossBar);
        if (this.mode.equals("single")) {
            this.singleBossBars.put(player.getUniqueId(), bossBar);
        } else {
            this.bossBars.get(player.getUniqueId()).put(skill, bossBar);
        }
        return bossBar;
    }

    private void handleExistingBossBar(BossBar bossBar, Player player, Skill skill, double currentXp, double levelXp, String text) {
        Component name = this.tf.toComponent(text);
        bossBar.name(name);
        double progress = currentXp / levelXp;
        if (progress > 1.0 || progress < 0.0) {
            progress = 1.0;
        }
        bossBar.progress((float)progress);
        bossBar.color(this.getColor(skill));
        this.plugin.getAudiences().player(player).showBossBar(bossBar);
    }

    private String getBossBarText(Player player, Skill skill, double currentXp, long levelXp, double xpGained, int level, boolean maxed, double income, Locale locale) {
        String bossBarText;
        String currentXpText = this.getCurrentXpText(currentXp);
        BukkitMessageProvider provider = this.plugin.getMessageProvider();
        if (!maxed) {
            ActionBarMessage key = income > 0.0 ? ActionBarMessage.BOSS_BAR_INCOME : ActionBarMessage.BOSS_BAR_XP;
            bossBarText = this.setPlaceholders(player, TextUtil.replace(provider.getRaw(key, locale), new String[]{"{skill}", skill.getDisplayName(locale, false), "{level}", RomanNumber.toRoman(level, this.plugin), "{current_xp}", currentXpText, "{level_xp}", this.getLevelXpText(levelXp), "{percent}", this.percentFormat.format(currentXp / (double)levelXp * 100.0), "{xp_gained}", xpGained > 0.0 ? "+" + this.xpFormat.format(xpGained) : this.xpFormat.format(xpGained), "{income}", this.moneyFormat.format(income)}));
        } else {
            ActionBarMessage key = income > 0.0 ? ActionBarMessage.BOSS_BAR_INCOME_MAXED : ActionBarMessage.BOSS_BAR_MAXED;
            bossBarText = this.setPlaceholders(player, TextUtil.replace(provider.getRaw(key, locale), "{skill}", skill.getDisplayName(locale, false), "{level}", RomanNumber.toRoman(level, this.plugin), "{current_xp}", currentXpText, "{xp_gained}", (String)(xpGained > 0.0 ? "+" + this.xpFormat.format(xpGained) : this.xpFormat.format(xpGained)), "{income}", this.moneyFormat.format(income)));
        }
        return bossBarText;
    }

    private String getLevelXpText(long levelXp) {
        if (this.plugin.configBoolean(Option.BOSS_BAR_USE_SUFFIX)) {
            return BigNumber.withSuffix(levelXp);
        }
        return String.valueOf(levelXp);
    }

    private String getCurrentXpText(double currentXp) {
        String currentXpText = this.plugin.configBoolean(Option.BOSS_BAR_ROUND_XP) ? String.valueOf(Math.round(currentXp)) : this.xpFormat.format(currentXp);
        return currentXpText;
    }

    public void incrementAction(Player player, Skill skill) {
        UUID playerId = player.getUniqueId();
        if (!this.singleCheckCurrentActions.containsKey(playerId)) {
            this.singleCheckCurrentActions.put(playerId, 0);
        }
        if (!this.checkCurrentActions.containsKey(playerId)) {
            this.checkCurrentActions.put(playerId, new HashMap());
        }
        if (this.mode.equals("single")) {
            this.singleCheckCurrentActions.put(playerId, this.singleCheckCurrentActions.get(playerId) + 1);
        } else {
            Integer currentAction = this.checkCurrentActions.get(playerId).get(skill);
            if (currentAction != null) {
                this.checkCurrentActions.get(playerId).put(skill, currentAction + 1);
            } else {
                this.checkCurrentActions.get(playerId).put(skill, 0);
            }
        }
    }

    private void scheduleHide(UUID playerId, Skill skill, BossBar bossBar) {
        if (this.mode.equals("single")) {
            int currentAction = this.singleCurrentActions.get(playerId);
            this.plugin.getScheduler().scheduleSync(() -> {
                if (!this.mode.equals("single")) {
                    return;
                }
                if (currentAction != this.singleCurrentActions.getOrDefault(playerId, 0)) {
                    return;
                }
                if (bossBar != null) {
                    this.plugin.getAudiences().player(playerId).hideBossBar(bossBar);
                }
                this.singleCheckCurrentActions.remove(playerId);
            }, (long)this.stayTime * 50L, TimeUnit.MILLISECONDS);
        } else {
            Map<Skill, Integer> multiCurrentActions = this.currentActions.get(playerId);
            if (multiCurrentActions == null) {
                return;
            }
            int currentAction = multiCurrentActions.get(skill);
            this.plugin.getScheduler().scheduleSync(() -> {
                if (this.mode.equals("single")) {
                    return;
                }
                Map<Skill, Integer> currActions = this.currentActions.get(playerId);
                if (currActions == null) {
                    return;
                }
                if (currentAction != currActions.getOrDefault(skill, 0)) {
                    return;
                }
                if (bossBar != null) {
                    this.plugin.getAudiences().player(playerId).hideBossBar(bossBar);
                }
                this.checkCurrentActions.remove(playerId);
            }, (long)this.stayTime * 50L, TimeUnit.MILLISECONDS);
        }
    }

    private BossBar.Color getColor(Skill skill) {
        return this.colors.getOrDefault(skill, BossBar.Color.GREEN);
    }

    private BossBar.Overlay getOverlay(Skill skill) {
        return this.overlays.getOrDefault(skill, BossBar.Overlay.PROGRESS);
    }

    public int getCurrentAction(Player player, Skill skill) {
        if (this.mode.equals("single")) {
            return this.singleCheckCurrentActions.get(player.getUniqueId());
        }
        Map<Skill, Integer> multiCurrentActions = this.checkCurrentActions.get(player.getUniqueId());
        if (multiCurrentActions != null) {
            return multiCurrentActions.get(skill);
        }
        return -1;
    }

    private String setPlaceholders(Player player, String input) {
        if (this.plugin.configBoolean(Option.BOSS_BAR_PLACEHOLDER_API) && this.plugin.getHookManager().isRegistered(PlaceholderHook.class)) {
            return this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(this.plugin.getUser(player), input);
        }
        return input;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.bossBars.remove(playerId);
        this.currentActions.remove(playerId);
        this.singleBossBars.remove(playerId);
        this.singleCurrentActions.remove(playerId);
        this.checkCurrentActions.remove(playerId);
        this.singleCheckCurrentActions.remove(playerId);
    }
}

