/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class MovementSpeedTrait
extends TraitImpl {
    MovementSpeedTrait(AuraSkills plugin) {
        super(plugin, Traits.MOVEMENT_SPEED);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (attribute == null) {
            return 100.0;
        }
        double totalValue = attribute.getValue();
        double ATTRIBUTE_RATIO = 1000.0;
        double baseValue = totalValue - this.getValue(player, trait, ATTRIBUTE_RATIO);
        return baseValue * ATTRIBUTE_RATIO;
    }

    @Override
    protected void reload(Player player, Trait trait) {
        double WALK_SPEED_RATIO = 500.0;
        double value = this.getValue(player, trait, WALK_SPEED_RATIO);
        if (!trait.isEnabled()) {
            return;
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            player.setWalkSpeed(0.2f);
            return;
        }
        double max = trait.optionDouble("max") / WALK_SPEED_RATIO;
        if (0.2 + value > max) {
            player.setWalkSpeed((float)max);
            return;
        }
        player.setWalkSpeed(Math.min((float)(0.2 + value), 1.0f));
    }

    @EventHandler
    public void onLoad(UserLoadEvent event) {
        this.reload(event.getPlayer(), this.getTraits()[0]);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void worldChange(PlayerChangedWorldEvent event) {
        this.reload(event.getPlayer(), this.getTraits()[0]);
    }

    private double getValue(Player player, Trait trait, double ratio) {
        User user = this.plugin.getUser(player);
        return user.getBonusTraitLevel(trait) / ratio;
    }
}

