/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class LuckTrait
extends TraitImpl {
    LuckTrait(AuraSkills plugin) {
        super(plugin, Traits.LUCK);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_LUCK);
        if (attribute == null) {
            return 0.0;
        }
        double current = attribute.getValue();
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!am.getName().equals("AureliumSkills-Luck")) continue;
            current -= am.getAmount();
        }
        return current;
    }

    @EventHandler
    public void onJoin(UserLoadEvent event) {
        this.setLuck(event.getPlayer());
    }

    @Override
    public void reload(Player player, Trait trait) {
        this.setLuck(player);
    }

    @EventHandler
    public void worldChange(PlayerChangedWorldEvent event) {
        this.setLuck(event.getPlayer());
    }

    private void setLuck(Player player) {
        if (!Traits.LUCK.isEnabled()) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_LUCK);
        if (attribute == null) {
            return;
        }
        boolean hasModifier = false;
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!am.getName().equals("AureliumSkills-Luck")) continue;
            attribute.removeModifier(am);
            hasModifier = true;
        }
        if (!hasModifier) {
            attribute.setBaseValue(0.0);
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return;
        }
        User user = this.plugin.getUser(player);
        double luck = user.getBonusTraitLevel(Traits.LUCK);
        attribute.addModifier(new AttributeModifier("AureliumSkills-Luck", luck, AttributeModifier.Operation.ADD_NUMBER));
    }
}

