/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.skills.agility.AgilityAbilities;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class HpTrait
extends TraitImpl {
    private final Map<UUID, Double> worldChangeHealth = new HashMap<UUID, Double>();
    private final Map<Integer, Double> hearts = new HashMap<Integer, Double>();
    private static final double threshold = 0.1;
    private final UUID ATTRIBUTE_ID = UUID.fromString("7d1423dd-91db-467a-8eb8-1886e30ca0b1");

    HpTrait(AuraSkills plugin) {
        super(plugin, Traits.HP);
        this.hearts.put(10, 0.0);
        this.hearts.put(11, 24.0);
        this.hearts.put(12, 29.0);
        this.hearts.put(13, 37.0);
        this.hearts.put(14, 50.0);
        this.hearts.put(15, 71.0);
        this.hearts.put(16, 105.0);
        this.hearts.put(17, 160.0);
        this.hearts.put(18, 249.0);
        this.hearts.put(19, 393.0);
        this.hearts.put(20, 626.0);
        this.loadHearts();
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return 0.0;
        }
        double current = attribute.getValue();
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!am.getName().equals("skillsHealth")) continue;
            current -= am.getAmount();
        }
        return current;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.applyScaling(event.getPlayer());
    }

    @Override
    public void reload(Player player, Trait trait) {
        this.setHealth(player, this.plugin.getUser(player));
        this.plugin.getAbilityManager().getAbilityImpl(AgilityAbilities.class).removeFleeting(player);
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        double scaling = trait.optionDouble("action_bar_scaling", 1.0);
        return NumberUtil.format1(scaling * value);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void worldChange(PlayerChangedWorldEvent event) {
        if (!Traits.HP.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) && !this.plugin.getWorldManager().isDisabledWorld(event.getFrom().getName())) {
            this.worldChangeHealth.put(player.getUniqueId(), player.getHealth());
        }
        User user = this.plugin.getUser(player);
        if (Traits.HP.optionInt("update_delay") > 0) {
            this.plugin.getScheduler().scheduleSync(() -> this.setWorldChange(event, player, user), (long)Traits.HP.optionInt("update_delay") * 50L, TimeUnit.MILLISECONDS);
        } else {
            this.setWorldChange(event, player, user);
        }
    }

    private void setWorldChange(PlayerChangedWorldEvent event, Player player, User user) {
        this.setHealth(player, user);
        if (this.plugin.getWorldManager().isDisabledWorld(event.getFrom().getName()) && !this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) && this.worldChangeHealth.containsKey(player.getUniqueId())) {
            player.setHealth(this.worldChangeHealth.get(player.getUniqueId()).doubleValue());
            this.worldChangeHealth.remove(player.getUniqueId());
        }
    }

    private void setHealth(Player player, User user) {
        Traits trait = Traits.HP;
        double modifier = user.getBonusTraitLevel(trait);
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        double originalMaxHealth = attribute.getValue();
        boolean hasChange = true;
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!am.getName().equals("skillsHealth")) continue;
            if (Math.abs(originalMaxHealth - (originalMaxHealth - am.getAmount() + modifier)) <= 0.1) {
                hasChange = false;
            }
            if (!hasChange) continue;
            attribute.removeModifier(am);
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) || !trait.isEnabled()) {
            player.setHealthScaled(false);
            for (AttributeModifier am : attribute.getModifiers()) {
                if (!am.getName().equals("skillsHealth")) continue;
                attribute.removeModifier(am);
            }
            if (player.getHealth() >= originalMaxHealth) {
                player.setHealth(attribute.getValue());
            }
            return;
        }
        if (trait.optionBoolean("force_base_health", false)) {
            attribute.setBaseValue(20.0);
        }
        if (hasChange) {
            attribute.addModifier(new AttributeModifier(this.ATTRIBUTE_ID, "skillsHealth", modifier, AttributeModifier.Operation.ADD_NUMBER));
            if (player.getHealth() > attribute.getValue()) {
                player.setHealth(attribute.getValue());
            }
            if (trait.optionBoolean("keep_full_on_increase", false) && attribute.getValue() > originalMaxHealth && player.getHealth() >= originalMaxHealth) {
                player.setHealth(attribute.getValue());
            }
        }
        this.applyScaling(player);
    }

    private void applyScaling(Player player) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        if (Traits.HP.isEnabled() && Traits.HP.optionBoolean("health_scaling", true)) {
            double health = attribute.getValue();
            player.setHealthScaled(true);
            int scaledHearts = 0;
            for (Integer heartNum : this.hearts.keySet()) {
                double healthNum = this.hearts.get(heartNum);
                if (!(health >= healthNum) || heartNum <= scaledHearts) continue;
                scaledHearts = heartNum;
            }
            if (scaledHearts == 0) {
                scaledHearts = 10;
            }
            player.setHealthScale((double)(scaledHearts * 2));
        } else if (Traits.HP.optionBoolean("ensure_scaling_disabled", true)) {
            player.setHealthScaled(false);
        }
    }

    public void loadHearts() {
        this.hearts.clear();
        Map<String, Object> map = Traits.HP.optionMap("hearts");
        try {
            for (String key : map.keySet()) {
                int heartsNum = Integer.parseInt(key);
                double healthNum = DataUtil.getDouble(map, key);
                if (healthNum == -1.0) continue;
                this.hearts.put(heartsNum, healthNum);
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("There was an error loading health.hearts data! Check to make sure the keys are only integers and the values are only numbers.");
        }
    }
}

