/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.AuraSkillsBukkit;
import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.event.skill.SkillLevelUpEvent;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.util.SlateMenuHelper;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.message.type.MenuMessage;
import dev.aurelium.auraskills.common.source.SourceTag;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GatheringLuckTraits
extends TraitImpl {
    private final Random random = new Random();
    private final SlateMenuHelper menuHelper;

    GatheringLuckTraits(AuraSkills plugin) {
        super(plugin, Traits.FARMING_LUCK, Traits.FORAGING_LUCK, Traits.MINING_LUCK, Traits.FISHING_LUCK, Traits.EXCAVATION_LUCK);
        this.menuHelper = new SlateMenuHelper(plugin.getSlate());
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        return 0.0;
    }

    public void apply(Trait trait, Block block, Player player, User user, XpSource source) {
        Skill skill = this.getSkill(trait);
        if (skill == null) {
            return;
        }
        SourceTag tag = this.getTag(skill);
        if (tag != null && !this.plugin.getSkillManager().hasTag(source, tag)) {
            return;
        }
        if (this.failsChecks(player, skill)) {
            return;
        }
        for (ItemStack item : this.getUniqueDrops(block, player)) {
            int numExtra = this.rollExtraDrops(user, trait);
            if (numExtra == 0) continue;
            ItemStack droppedItem = item.clone();
            droppedItem.setAmount(numExtra);
            Location location = block.getLocation().add(0.5, 0.5, 0.5);
            boolean toInventory = this.plugin.getLootTableManager().toInventory(player.getInventory().getItemInMainHand());
            LootDropEvent.Cause cause = this.getCause(skill);
            LootDropEvent event = new LootDropEvent(player, user.toApi(), droppedItem, location, cause, toInventory);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            ItemUtils.giveBlockLoot(player, event);
        }
    }

    @Override
    protected void reload(Player player, Trait trait) {
        User user = this.plugin.getUser(player);
        Ability ability = this.getAbility(trait);
        if (ability == null) {
            return;
        }
        if (!ability.isEnabled()) {
            return;
        }
        String modifierName = trait.name().toLowerCase(Locale.ROOT) + "_ability";
        double value = ability.getValue(user.getAbilityLevel(ability));
        if (value != 0.0) {
            user.addTraitModifier(new TraitModifier(modifierName, trait, value), false);
        } else {
            user.removeTraitModifier(modifierName);
        }
    }

    @EventHandler
    public void onLevelUp(SkillLevelUpEvent event) {
        Trait trait = this.getTrait(event.getSkill());
        if (trait == null) {
            return;
        }
        Player player = event.getPlayer();
        this.reload(player, trait);
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        int guaranteed = this.getGuaranteedExtra(value);
        double chance = value - (double)(guaranteed * 100);
        String desc = guaranteed >= 1 && chance > 0.0 ? TextUtil.replace(this.menuHelper.getFormat("stats", "luck_trait_desc_both"), "{added}", this.getAddedMsg(guaranteed, locale), "{chance}", this.getChanceMsg(chance, guaranteed, locale)) : (guaranteed >= 1 && chance == 0.0 ? TextUtil.replace(this.menuHelper.getFormat("stats", "luck_trait_desc_added"), "{added}", this.getAddedMsg(guaranteed, locale)) : (chance > 0.0 ? TextUtil.replace(this.menuHelper.getFormat("stats", "luck_trait_desc_chance"), "{chance}", this.getChanceMsg(chance, guaranteed, locale)) : ""));
        return NumberUtil.format1(value) + desc;
    }

    private String getAddedMsg(int guaranteed, Locale locale) {
        MenuMessage key = guaranteed == 1 ? MenuMessage.ADDED_DROP : MenuMessage.ADDED_DROPS;
        return TextUtil.replace(this.plugin.getMsg(key, locale), "{value}", String.valueOf(guaranteed));
    }

    private String getChanceMsg(double chance, int guaranteed, Locale locale) {
        MenuMessage key = guaranteed + 1 == 1 ? MenuMessage.CHANCE_DROP : MenuMessage.CHANCE_DROPS;
        return TextUtil.replace(this.plugin.getMsg(key, locale), "{chance}", NumberUtil.format1(chance), "{value}", String.valueOf(guaranteed + 1));
    }

    private Set<ItemStack> getUniqueDrops(Block block, Player player) {
        HashSet<ItemStack> unique = new HashSet<ItemStack>();
        for (ItemStack item : block.getDrops(player.getInventory().getItemInMainHand(), (Entity)player)) {
            boolean alreadyAdded = false;
            for (ItemStack existing : unique) {
                if (!existing.isSimilar(item)) continue;
                alreadyAdded = true;
                break;
            }
            if (alreadyAdded) continue;
            unique.add(item);
        }
        return unique;
    }

    private boolean failsChecks(Player player, Skill skill) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        if (!this.plugin.getUser(player).hasSkillPermission(skill)) {
            return true;
        }
        return AuraSkillsBukkit.get().getLocationManager().isPluginDisabled(player.getLocation(), player);
    }

    private int getGuaranteedExtra(double value) {
        return (int)(value / 100.0);
    }

    public int rollExtraDrops(User user, Trait trait) {
        double value = user.getEffectiveTraitLevel(trait);
        if (value == 0.0) {
            return 0;
        }
        int guaranteed = this.getGuaranteedExtra(value);
        double chance = (value - (double)(guaranteed * 100)) / 100.0;
        int extra = this.random.nextDouble() < chance ? 1 : 0;
        return guaranteed + extra;
    }

    @Nullable
    public Skill getSkill(Trait trait) {
        if (trait instanceof Traits) {
            Traits defTrait = (Traits)trait;
            return switch (defTrait) {
                case Traits.FARMING_LUCK -> Skills.FARMING;
                case Traits.FORAGING_LUCK -> Skills.FORAGING;
                case Traits.MINING_LUCK -> Skills.MINING;
                case Traits.EXCAVATION_LUCK -> Skills.EXCAVATION;
                case Traits.FISHING_LUCK -> Skills.FISHING;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    public Trait getTrait(Skill skill) {
        if (skill instanceof Skills) {
            Skills skills = (Skills)skill;
            return switch (skills) {
                case Skills.FARMING -> Traits.FARMING_LUCK;
                case Skills.FORAGING -> Traits.FORAGING_LUCK;
                case Skills.MINING -> Traits.MINING_LUCK;
                case Skills.EXCAVATION -> Traits.EXCAVATION_LUCK;
                case Skills.FISHING -> Traits.FISHING_LUCK;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    public Ability getAbility(Trait trait) {
        if (trait instanceof Traits) {
            Traits traits = (Traits)trait;
            return switch (traits) {
                case Traits.FARMING_LUCK -> Abilities.BOUNTIFUL_HARVEST;
                case Traits.FORAGING_LUCK -> Abilities.LUMBERJACK;
                case Traits.MINING_LUCK -> Abilities.LUCKY_MINER;
                case Traits.EXCAVATION_LUCK -> Abilities.BIGGER_SCOOP;
                case Traits.FISHING_LUCK -> Abilities.LUCKY_CATCH;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    public SourceTag getTag(Skill skill) {
        if (skill instanceof Skills) {
            Skills skills = (Skills)skill;
            return switch (skills) {
                case Skills.FARMING -> SourceTag.FARMING_LUCK_APPLICABLE;
                case Skills.FORAGING -> SourceTag.FORAGING_LUCK_APPLICABLE;
                case Skills.MINING -> SourceTag.MINING_LUCK_APPLICABLE;
                case Skills.EXCAVATION -> SourceTag.EXCAVATION_LUCK_APPLICABLE;
                default -> null;
            };
        }
        return null;
    }

    @NotNull
    private LootDropEvent.Cause getCause(Skill skill) {
        if (skill instanceof Skills) {
            Skills skills = (Skills)skill;
            return switch (skills) {
                case Skills.FARMING -> LootDropEvent.Cause.FARMING_LUCK;
                case Skills.FORAGING -> LootDropEvent.Cause.FORAGING_LUCK;
                case Skills.MINING -> LootDropEvent.Cause.MINING_LUCK;
                case Skills.FISHING -> LootDropEvent.Cause.FISHING_LUCK;
                case Skills.EXCAVATION -> LootDropEvent.Cause.EXCAVATION_LUCK;
                default -> LootDropEvent.Cause.UNKNOWN;
            };
        }
        return LootDropEvent.Cause.UNKNOWN;
    }
}

