/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardFlags;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardHook;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class DoubleDropTrait
extends TraitImpl {
    private final Random r = new Random();

    DoubleDropTrait(AuraSkills plugin) {
        super(plugin, Traits.DOUBLE_DROP);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        return 0.0;
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        return NumberUtil.format1(value) + "%";
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        WorldGuardHook worldGuard;
        if (!Traits.DOUBLE_DROP.isEnabled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (block.hasMetadata("blockbreakevent-ignore")) {
            return;
        }
        if (this.plugin.getWorldManager().isInBlockedWorld(block.getLocation())) {
            return;
        }
        if (this.plugin.getHookManager().isRegistered(WorldGuardHook.class) && (worldGuard = this.plugin.getHookManager().getHook(WorldGuardHook.class)).isBlocked(block.getLocation(), player, WorldGuardFlags.FlagKey.XP_GAIN)) {
            return;
        }
        if (!event.isDropItems()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (this.plugin.getRegionManager().isPlacedBlock(block)) {
            return;
        }
        User user = this.plugin.getUser(player);
        Material mat = block.getType();
        if (mat.equals((Object)Material.STONE) || mat.equals((Object)Material.COBBLESTONE) || mat.equals((Object)Material.SAND) || mat.equals((Object)Material.GRAVEL) || mat.equals((Object)Material.DIRT) || mat.equals((Object)Material.GRASS_BLOCK) || mat.equals((Object)Material.ANDESITE) || mat.equals((Object)Material.DIORITE) || mat.equals((Object)Material.GRANITE)) {
            double maxPercent;
            double percentChance = user.getEffectiveTraitLevel(Traits.DOUBLE_DROP);
            if (percentChance > (maxPercent = Traits.DOUBLE_DROP.optionDouble("max_percent"))) {
                percentChance = maxPercent;
            }
            double chance = percentChance / 100.0;
            if (this.r.nextDouble() < chance) {
                ItemStack tool = player.getInventory().getItemInMainHand();
                Location location = block.getLocation().add(0.5, 0.5, 0.5);
                for (ItemStack item : block.getDrops(tool)) {
                    ItemStack itemToDrop = tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0 ? (mat.equals((Object)Material.STONE) ? new ItemStack(Material.STONE) : (mat.equals((Object)Material.GRASS_BLOCK) ? new ItemStack(Material.GRASS_BLOCK) : item.clone())) : item.clone();
                    boolean toInventory = this.plugin.getLootTableManager().toInventory(player.getInventory().getItemInMainHand());
                    LootDropEvent lootDropEvent = new LootDropEvent(player, user.toApi(), itemToDrop, location, LootDropEvent.Cause.LUCK_DOUBLE_DROP, toInventory);
                    Bukkit.getPluginManager().callEvent((Event)lootDropEvent);
                    if (lootDropEvent.isCancelled()) continue;
                    ItemUtils.giveBlockLoot(player, lootDropEvent);
                }
            }
        }
    }
}

