/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.parser.ParseException;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.Nullable;

public class DamageReductionTrait
extends TraitImpl {
    @Nullable
    private Expression formula;

    DamageReductionTrait(AuraSkills plugin) {
        super(plugin, Traits.DAMAGE_REDUCTION);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        return 0.0;
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        return NumberUtil.format1(this.getReductionValue(value) * 100.0) + "%";
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player player = meta.getTargetAsPlayer();
        if (player != null) {
            User user = this.plugin.getUser(player);
            double reduction = user.getEffectiveTraitLevel(Traits.DAMAGE_REDUCTION);
            meta.addDefenseModifier(new DamageModifier(1.0 - this.getReductionValue(reduction) - 1.0, DamageModifier.Operation.MULTIPLY));
        }
    }

    public void resetFormula() {
        this.formula = null;
    }

    private double getReductionValue(double value) {
        Traits trait = Traits.DAMAGE_REDUCTION;
        if (this.formula == null) {
            this.formula = new Expression(trait.optionString("formula"));
        }
        this.formula.with("value", value);
        try {
            return this.formula.evaluate().getNumberValue().doubleValue();
        }
        catch (EvaluationException | ParseException e) {
            this.plugin.logger().warn("Failed to evaluate formula for trait auraskills/damage_reduction: " + e.getMessage());
            return -1.0 * Math.pow(1.01, -1.0 * value) + 1.0;
        }
    }
}

