/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;

public class AnvilDiscountTrait
extends TraitImpl {
    AnvilDiscountTrait(AuraSkills plugin) {
        super(plugin, Traits.ANVIL_DISCOUNT);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        return 0.0;
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        return NumberUtil.format1(this.getDiscount(value) * 100.0) + "%";
    }

    @EventHandler
    public void onAnvilPrepare(PrepareAnvilEvent event) {
        User user = null;
        for (HumanEntity entity : event.getViewers()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            User checkedUser = this.plugin.getUser(player);
            if (user == null) {
                user = checkedUser;
                continue;
            }
            if (!(user.getStatLevel(Stats.WISDOM) < checkedUser.getStatLevel(Stats.WISDOM))) continue;
            user = checkedUser;
        }
        if (user != null) {
            AnvilInventory anvil = event.getInventory();
            double wisdom = user.getEffectiveTraitLevel(Traits.ANVIL_DISCOUNT);
            int cost = (int)Math.round((double)anvil.getRepairCost() * (1.0 - this.getDiscount(wisdom)));
            if (cost > 0) {
                anvil.setRepairCost(cost);
            } else {
                anvil.setRepairCost(1);
            }
        }
    }

    private double getDiscount(double wisdom) {
        return -1.0 * Math.pow(1.025, -1.0 * wisdom) + 1.0;
    }
}

