/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.StatisticXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class StatisticLeveler
extends SourceLeveler {
    private final Map<UUID, Map<StatisticXpSource, Integer>> tracker = new HashMap<UUID, Map<StatisticXpSource, Integer>>();

    public StatisticLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.STATISTIC);
        this.startTracking();
    }

    public void startTracking() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    StatisticLeveler.this.handlePlayer(player);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.SOURCE_STATISTIC_GAIN_PERIOD_TICKS) * 50L, TimeUnit.MILLISECONDS);
    }

    private void handlePlayer(Player player) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        User user = this.plugin.getUser(player);
        List<SkillSource<StatisticXpSource>> sources = this.plugin.getSkillManager().getSourcesOfType(StatisticXpSource.class);
        for (SkillSource<StatisticXpSource> entry : sources) {
            if (this.failsChecks(player, player.getLocation(), entry.skill())) {
                return;
            }
            StatisticXpSource source = entry.source();
            try {
                Statistic statistic = Statistic.valueOf((String)source.getStatistic().toUpperCase(Locale.ROOT));
                int lastValue = this.tracker.computeIfAbsent(player.getUniqueId(), uuid -> new HashMap()).computeIfAbsent(source, s -> player.getStatistic(statistic));
                int change = player.getStatistic(statistic) - lastValue;
                if (change <= 0 || change < source.getMinimumIncrease()) continue;
                double xpToAdd = (double)change * source.getMultiplier() * source.getXp();
                this.plugin.getLevelManager().addXp(user, entry.skill(), source, xpToAdd);
                this.tracker.computeIfAbsent(player.getUniqueId(), uuid -> new HashMap()).put(source, player.getStatistic(statistic));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

