/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.GrindstoneXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class GrindstoneLeveler
extends SourceLeveler {
    public GrindstoneLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.GRINDSTONE);
    }

    @EventHandler
    public void onGrindstoneDisenchant(InventoryClickEvent event) {
        Location location;
        if (this.disabled()) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.failsClickChecks(event)) {
            return;
        }
        if (!inventory.getType().equals((Object)InventoryType.GRINDSTONE)) {
            return;
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        SkillSource<GrindstoneXpSource> skillSource = this.plugin.getSkillManager().getSingleSourceOfType(GrindstoneXpSource.class);
        if (skillSource == null) {
            return;
        }
        GrindstoneXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        Location location2 = location = inventory.getLocation() != null ? inventory.getLocation() : player.getLocation();
        if (this.failsChecks((Cancellable)event, player, location, skill)) {
            return;
        }
        double multiplier = this.getTotalLevelMultiplier(source, inventory, skill);
        this.plugin.getLevelManager().addXp(this.plugin.getUser(player), skill, source, multiplier * source.getXp());
    }

    private double getTotalLevelMultiplier(GrindstoneXpSource source, Inventory inventory, Skill skill) {
        double multiplier = 1.0;
        String multiplierString = source.getMultiplier();
        if (multiplierString != null) {
            int totalLevel = 0;
            ItemStack topItem = inventory.getItem(0);
            totalLevel += this.getTotalLevel(topItem);
            ItemStack bottomItem = inventory.getItem(1);
            multiplierString = TextUtil.replace(multiplierString, "{total_level}", String.valueOf(totalLevel += this.getTotalLevel(bottomItem)));
            try {
                multiplier = Double.parseDouble(multiplierString);
            }
            catch (NumberFormatException e) {
                this.plugin.logger().warn("Invalid multiplier for grindstone source " + source.getId() + " in skill " + skill.getId());
                e.printStackTrace();
            }
        }
        return multiplier;
    }

    private int getTotalLevel(ItemStack item) {
        int totalLevel = 0;
        if (item != null) {
            for (Map.Entry entry : item.getEnchantments().entrySet()) {
                if (!this.isDisenchantable((Enchantment)entry.getKey())) continue;
                totalLevel += ((Integer)entry.getValue()).intValue();
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)itemMeta;
                for (Map.Entry entry : esm.getStoredEnchants().entrySet()) {
                    if (!this.isDisenchantable((Enchantment)entry.getKey())) continue;
                    totalLevel += ((Integer)entry.getValue()).intValue();
                }
            }
        }
        return totalLevel;
    }

    public boolean isDisenchantable(Enchantment enchant) {
        if (enchant.equals(Enchantment.BINDING_CURSE) || enchant.equals(Enchantment.VANISHING_CURSE)) {
            return false;
        }
        List blockedList = this.plugin.configStringList(Option.SOURCE_GRINDSTONE_BLOCKED_ENCHANTS);
        for (String blockedEnchantName : blockedList) {
            if (!enchant.getKey().getKey().equalsIgnoreCase(blockedEnchantName)) continue;
            return false;
        }
        return true;
    }
}

