/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.DamageXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DamageLeveler
extends SourceLeveler {
    public DamageLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.DAMAGE);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        EntityDamageByEntityEvent entityEvent;
        if (this.disabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.hasMetadata("NPC")) {
            return;
        }
        SkillSource<DamageXpSource> skillSource = this.getSource(event);
        if (skillSource == null) {
            return;
        }
        DamageXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (event instanceof EntityDamageByEntityEvent && this.isSelfInflicted((entityEvent = (EntityDamageByEntityEvent)event).getDamager(), player)) {
            return;
        }
        if (this.failsChecks((Cancellable)event, player, player.getLocation(), skill)) {
            return;
        }
        if (skill.equals(Skills.DEFENSE) && !Skills.DEFENSE.optionBoolean("allow_shield_blocking", false) && player.isBlocking()) {
            return;
        }
        double damage = source.useOriginalDamage() ? event.getOriginalDamage(EntityDamageEvent.DamageModifier.BASE) : event.getFinalDamage();
        if (source.mustSurvive() && event.getFinalDamage() >= player.getHealth()) {
            return;
        }
        double xp = damage * source.getXp();
        if (skill.equals(Skills.DEFENSE) && (xp = Math.min(xp, Skills.DEFENSE.optionDouble("max", 100.0))) < Skills.DEFENSE.optionDouble("min", 0.0)) {
            return;
        }
        User user = this.plugin.getUser(player);
        Entity damager = null;
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityEvent2 = (EntityDamageByEntityEvent)event;
            damager = entityEvent2.getDamager();
        }
        this.plugin.getLevelManager().addDamageXp(user, skill, source, xp, DamageXpSource.DamageCause.valueOf(event.getCause().name()), damager, (EntityEvent)event);
    }

    private boolean isSelfInflicted(Entity damager, Player player) {
        Projectile projectile;
        ProjectileSource projectileSource;
        if (damager instanceof Player) {
            return damager.equals(player);
        }
        if (damager instanceof Projectile && (projectileSource = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
            Player shooter = (Player)projectileSource;
            return shooter.equals(player);
        }
        return false;
    }

    private SkillSource<DamageXpSource> getSource(EntityDamageEvent event) {
        List<SkillSource<DamageXpSource>> sources = this.plugin.getSkillManager().getSourcesOfType(DamageXpSource.class);
        for (SkillSource<DamageXpSource> entry : sources) {
            EntityDamageByEntityEvent entityEvent;
            DamageXpSource.DamageCause[] excludedCauses;
            DamageXpSource source = entry.source();
            DamageXpSource.DamageCause[] causes = source.getCauses();
            if (causes != null) {
                boolean matchingCause = false;
                for (DamageXpSource.DamageCause cause : causes) {
                    if (!cause.toString().equals(event.getCause().toString())) continue;
                    matchingCause = true;
                    break;
                }
                if (!matchingCause) continue;
            }
            if ((excludedCauses = source.getExcludedCauses()) != null) {
                boolean matchingCause = false;
                for (DamageXpSource.DamageCause cause : excludedCauses) {
                    if (!cause.toString().equals(event.getCause().toString())) continue;
                    matchingCause = true;
                    break;
                }
                if (matchingCause) continue;
            }
            if (source.getDamager() != null && (!(event instanceof EntityDamageByEntityEvent) || !this.damagerMatches(source, (entityEvent = (EntityDamageByEntityEvent)event).getDamager(), source.getDamager()))) continue;
            return entry;
        }
        return null;
    }

    private boolean damagerMatches(DamageXpSource source, Entity damager, String name) {
        if (source.includeProjectiles() && damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            return this.projectileSourceMatches(projectile.getShooter(), name);
        }
        return this.entityDamagerMatches(damager, name);
    }

    private boolean entityDamagerMatches(Entity damager, String name) {
        if (name.equalsIgnoreCase("mob")) {
            return damager instanceof Mob;
        }
        return damager.getType().toString().equalsIgnoreCase(name);
    }

    private boolean projectileSourceMatches(ProjectileSource projectileSource, String name) {
        if (name.equalsIgnoreCase("mob")) {
            return projectileSource instanceof Mob;
        }
        if (projectileSource instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)projectileSource;
            return livingEntity.getType().toString().equalsIgnoreCase(name);
        }
        return false;
    }
}

