/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.config.Option;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.SeaPickle;

public class BlockLevelerHelper {
    private final AuraSkills plugin;

    public BlockLevelerHelper(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public int getBlocksBroken(Block block, BlockXpSource source) {
        Material mat = block.getType();
        if (mat == Material.SUGAR_CANE) {
            int num = 1;
            BlockState above = block.getRelative(BlockFace.UP).getState();
            if (above.getType() == Material.SUGAR_CANE) {
                BlockState aboveAbove;
                if (!this.plugin.getRegionManager().isPlacedBlock(above.getBlock()) || !this.checkReplace()) {
                    ++num;
                }
                if (!((aboveAbove = block.getRelative(BlockFace.UP).getRelative(BlockFace.UP).getState()).getType() != Material.SUGAR_CANE || this.plugin.getRegionManager().isPlacedBlock(aboveAbove.getBlock()) && this.checkReplace())) {
                    ++num;
                }
            }
            return num;
        }
        if (mat == Material.BAMBOO || mat == Material.CACTUS || mat == Material.KELP_PLANT) {
            int num = 1;
            if (this.checkReplace() && this.plugin.getRegionManager().isPlacedBlock(block)) {
                Block above = block.getRelative(BlockFace.UP);
                if (!this.sourceMatches(block, source) || this.plugin.getRegionManager().isPlacedBlock(above)) {
                    return 0;
                }
                num = 0;
            }
            return num += this.getSameBlocksAbove(block.getRelative(BlockFace.UP), source, 0);
        }
        return 1;
    }

    public double getStateMultiplier(Block block, BlockXpSource source) {
        if (!source.hasStateMultiplier()) {
            return 1.0;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return source.getStateMultiplier("age", ageable.getAge());
        }
        blockData = block.getBlockData();
        if (blockData instanceof SeaPickle) {
            SeaPickle seaPickle = (SeaPickle)blockData;
            return source.getStateMultiplier("pickles", seaPickle.getPickles());
        }
        return source.getStateMultiplier("placeholder", 1.0);
    }

    private int getSameBlocksAbove(Block block, BlockXpSource source, int num) {
        if (this.sourceMatches(block, source)) {
            if (this.checkReplace() && this.plugin.getRegionManager().isPlacedBlock(block)) {
                return num;
            }
            return this.getSameBlocksAbove(block.getRelative(BlockFace.UP), source, ++num);
        }
        return num;
    }

    private boolean sourceMatches(Block block, BlockXpSource source) {
        for (String blockName : source.getBlocks()) {
            if (!block.getType().name().equalsIgnoreCase(blockName)) continue;
            return true;
        }
        return false;
    }

    private boolean checkReplace() {
        return this.plugin.configBoolean(Option.CHECK_BLOCK_REPLACE_ENABLED);
    }
}

