/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.skills.mining.MiningAbilities;
import dev.aurelium.auraskills.bukkit.source.BlockLevelerHelper;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.bukkit.trait.GatheringLuckTraits;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BlockLeveler
extends SourceLeveler {
    private final BlockLevelerHelper helper;
    private final Map<UniqueBlock, SkillSource<BlockXpSource>> sourceCache;

    public BlockLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.BLOCK);
        this.helper = new BlockLevelerHelper(plugin);
        this.sourceCache = new HashMap<UniqueBlock, SkillSource<BlockXpSource>>();
    }

    public void clearSourceCache() {
        this.sourceCache.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        if (this.disabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.hasMetadata("blockbreakevent-ignore")) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.plugin.getUser(player);
        SkillSource<BlockXpSource> skillSource = this.getSource(event.getBlock(), BlockXpSource.BlockTriggers.BREAK);
        if (skillSource == null) {
            return;
        }
        BlockXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, event.getBlock().getLocation(), skill)) {
            return;
        }
        if (source.checkReplace() && this.plugin.getRegionManager().isPlacedBlock(event.getBlock())) {
            MiningAbilities miningAbilities = this.plugin.getAbilityManager().getAbilityImpl(MiningAbilities.class);
            if (miningAbilities.dropsMineralDirectly(event.getBlock())) {
                this.applyBlockLuck(skill, player, user, event.getBlock(), source);
            }
            return;
        }
        double multiplier = this.helper.getBlocksBroken(event.getBlock(), source);
        this.plugin.getLevelManager().addXp(user, skill, source, source.getXp() * (multiplier *= this.helper.getStateMultiplier(event.getBlock(), source)));
        this.applyBlockLuck(skill, player, user, event.getBlock(), source);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        if (this.disabled()) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.plugin.getUser(player);
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        SkillSource<BlockXpSource> skillSource = this.getSource(block, BlockXpSource.BlockTriggers.INTERACT);
        if (skillSource == null) {
            return;
        }
        BlockXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, block.getLocation(), skill)) {
            return;
        }
        double multiplier = (double)this.helper.getBlocksBroken(block, source) * this.helper.getStateMultiplier(block, source);
        Material materialBefore = block.getType();
        if (source.getAfterStates() != null) {
            this.plugin.getScheduler().scheduleSync(() -> {
                if (materialBefore == block.getType() && this.matchesStates(block, source.getAfterStates())) {
                    this.plugin.getLevelManager().addXp(user, skill, source, source.getXp() * multiplier);
                    this.applyBlockLuck(skill, player, user, block, source);
                }
            }, 50L, TimeUnit.MILLISECONDS);
        } else {
            this.plugin.getLevelManager().addXp(user, skill, source, source.getXp() * multiplier);
            this.applyBlockLuck(skill, player, user, block, source);
        }
    }

    private void applyBlockLuck(Skill skill, Player player, User user, Block block, XpSource source) {
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0 && this.plugin.getAbilityManager().getAbilityImpl(MiningAbilities.class).dropsMineralDirectly(block)) {
            return;
        }
        GatheringLuckTraits traitImpl = this.plugin.getTraitManager().getTraitImpl(GatheringLuckTraits.class);
        Trait blockLuckTrait = traitImpl.getTrait(skill);
        if (blockLuckTrait != null) {
            traitImpl.apply(blockLuckTrait, block, player, user, source);
        }
    }

    public boolean isDifferentSource(Block block, BlockXpSource source, BlockXpSource.BlockTriggers trigger) {
        SkillSource<BlockXpSource> skillSource = this.getSource(block, trigger);
        if (skillSource == null) {
            return true;
        }
        return !skillSource.source().equals(source);
    }

    @Nullable
    public SkillSource<BlockXpSource> getSource(Block block, BlockXpSource.BlockTriggers trigger) {
        if (block.getType().isAir()) {
            return null;
        }
        UniqueBlock cacheKey = new UniqueBlock(block.getType(), block.getBlockData().getAsString(true), trigger);
        SkillSource<BlockXpSource> cachedSource = this.sourceCache.get(cacheKey);
        if (cachedSource != null) {
            return cachedSource;
        }
        List<SkillSource<BlockXpSource>> sources = this.plugin.getSkillManager().getSourcesOfType(BlockXpSource.class);
        sources = this.filterByTrigger(sources, trigger);
        for (SkillSource<BlockXpSource> entry : sources) {
            BlockXpSource source = entry.source();
            boolean blockMatches = false;
            for (String blockName : source.getBlocks()) {
                if (!block.getType().name().equalsIgnoreCase(blockName)) continue;
                blockMatches = true;
                break;
            }
            if (!blockMatches || source.getStates() != null && !this.matchesStates(block, source.getStates())) continue;
            this.sourceCache.put(cacheKey, entry);
            return entry;
        }
        return null;
    }

    private boolean matchesStates(Block block, BlockXpSource.BlockXpSourceState[] states) {
        String blockDataString = block.getBlockData().getAsString(true);
        Map<String, Object> blockDataMap = this.parseFromBlockData(blockDataString);
        for (BlockXpSource.BlockXpSourceState state : states) {
            if (state == null) continue;
            boolean stateMatches = true;
            for (Map.Entry<String, Object> stateEntry : state.getStateMap().entrySet()) {
                String key = stateEntry.getKey();
                Object value = stateEntry.getValue();
                if (!blockDataMap.containsKey(key)) {
                    stateMatches = false;
                    break;
                }
                if (blockDataMap.get(key).equals(value)) continue;
                stateMatches = false;
                break;
            }
            if (!stateMatches) continue;
            return true;
        }
        return false;
    }

    private List<SkillSource<BlockXpSource>> filterByTrigger(List<SkillSource<BlockXpSource>> sources, BlockXpSource.BlockTriggers trigger) {
        ArrayList<SkillSource<BlockXpSource>> filtered = new ArrayList<SkillSource<BlockXpSource>>();
        block0: for (SkillSource<BlockXpSource> entry : sources) {
            BlockXpSource source = entry.source();
            for (BlockXpSource.BlockTriggers sourceTrigger : source.getTriggers()) {
                if (sourceTrigger != trigger) continue;
                filtered.add(entry);
                continue block0;
            }
        }
        return filtered;
    }

    private Map<String, Object> parseFromBlockData(String input) {
        int equalIndex;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (input == null || input.isEmpty()) {
            return result;
        }
        int bracketIndex = input.indexOf("[");
        if (bracketIndex == -1) {
            return result;
        }
        String data = input.substring(bracketIndex + 1).replace("]", "");
        int commaIndex = data.indexOf(",");
        while (commaIndex != -1) {
            String pair = data.substring(0, commaIndex);
            int equalIndex2 = pair.indexOf("=");
            if (equalIndex2 != -1) {
                String key = pair.substring(0, equalIndex2).trim();
                String value = pair.substring(equalIndex2 + 1).trim();
                result.put(key, this.parseValue(value));
            }
            data = data.substring(commaIndex + 1);
            commaIndex = data.indexOf(",");
        }
        if (!data.isEmpty() && (equalIndex = data.indexOf("=")) != -1) {
            String key = data.substring(0, equalIndex).trim();
            String value = data.substring(equalIndex + 1).trim();
            result.put(key, this.parseValue(value));
        }
        return result;
    }

    private Object parseValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException2) {
                if (value.equals("true")) {
                    return true;
                }
                if (value.equals("false")) {
                    return false;
                }
                return value;
            }
        }
    }

    public record UniqueBlock(Material material, String blockData, BlockXpSource.BlockTriggers trigger) {
    }
}

