/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.foraging;

import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ReadiedManaAbility;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.bukkit.util.BlockFaceUtil;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.jetbrains.annotations.Nullable;

public class Treecapitator
extends ReadiedManaAbility {
    private final boolean GIVE_XP = ManaAbilities.TREECAPITATOR.optionBoolean("give_xp", true);

    public Treecapitator(AuraSkills plugin) {
        super(plugin, ManaAbilities.TREECAPITATOR, ManaAbilityMessage.TREECAPITATOR_START, ManaAbilityMessage.TREECAPITATOR_END, new String[]{"_AXE"}, new Action[]{Action.RIGHT_CLICK_AIR, Action.RIGHT_CLICK_BLOCK});
    }

    @Override
    public void onActivate(Player player, User user) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    @Override
    public void onStop(Player player, User user) {
    }

    @Override
    protected boolean materialMatches(String checked) {
        if ((checked.equals("WOODEN_AXE") || checked.equals("WOOD_AXE")) && this.plugin.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
            return false;
        }
        for (String material : this.getMaterials()) {
            if (!checked.contains(material)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent event) {
        if (this.isDisabled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (this.plugin.getRegionManager().isPlacedBlock(block)) {
            return;
        }
        if (block.hasMetadata("blockbreakevent-ignore")) {
            return;
        }
        BlockXpSource source = this.getSource(block);
        if (this.isTrunk(source) || block.getType().toString().contains("STRIPPED")) {
            Player player = event.getPlayer();
            if (this.failsChecks(player)) {
                return;
            }
            User user = this.plugin.getUser(player);
            if (this.isActivated(user)) {
                this.breakTree(user, block, source);
                return;
            }
            if (this.isHoldingMaterial(player) && this.checkActivation(player)) {
                this.breakTree(user, block, source);
            }
        }
    }

    public void breakTree(User user, Block block, BlockXpSource source) {
        this.breakBlock(user, block, new TreecapitatorTree(this.plugin, block, source));
    }

    private void breakBlock(User user, Block block, TreecapitatorTree tree) {
        if (tree.getBlocksBroken() > tree.getMaxBlocks()) {
            return;
        }
        for (Block adjacentBlock : BlockFaceUtil.getSurroundingBlocks(block)) {
            BlockXpSource adjSource = this.getSource(adjacentBlock);
            boolean isTrunk = this.isTrunk(adjSource);
            boolean isLeaf = this.isLeaf(adjSource);
            if (!isTrunk && !isLeaf && !adjacentBlock.getType().toString().equals("SHROOMLIGHT") || this.plugin.getRegionManager().isPlacedBlock(adjacentBlock)) continue;
            adjacentBlock.breakNaturally();
            tree.incrementBlocksBroken();
            if (adjSource != null && this.GIVE_XP) {
                this.plugin.getLevelManager().addXp(user, this.manaAbility.getSkill(), adjSource, adjSource.getXp());
            }
            Block originalBlock = tree.getOriginalBlock();
            if (adjacentBlock.getX() > originalBlock.getX() + 6 || adjacentBlock.getZ() > originalBlock.getZ() + 6 || adjacentBlock.getY() > originalBlock.getY() + 31) {
                return;
            }
            this.plugin.getScheduler().scheduleSync(() -> this.breakBlock(user, adjacentBlock, tree), 50L, TimeUnit.MILLISECONDS);
        }
    }

    @Nullable
    private BlockXpSource getSource(Block block) {
        SkillSource<BlockXpSource> skillSource = this.plugin.getLevelManager().getLeveler(BlockLeveler.class).getSource(block, BlockXpSource.BlockTriggers.BREAK);
        if (skillSource != null) {
            return skillSource.source();
        }
        return null;
    }

    private boolean isTrunk(BlockXpSource source) {
        return source != null && source.isTrunk();
    }

    private boolean isLeaf(BlockXpSource source) {
        return source != null && source.isLeaf();
    }

    private static class TreecapitatorTree {
        private final AuraSkills plugin;
        private final Block originalBlock;
        private int blocksBroken;
        private int maxBlocks;

        public TreecapitatorTree(AuraSkills plugin, Block originalBlock, BlockXpSource source) {
            this.plugin = plugin;
            this.originalBlock = originalBlock;
            this.setMaxBlocks(source);
        }

        public Block getOriginalBlock() {
            return this.originalBlock;
        }

        public int getBlocksBroken() {
            return this.blocksBroken;
        }

        public void incrementBlocksBroken() {
            ++this.blocksBroken;
        }

        public int getMaxBlocks() {
            return this.maxBlocks;
        }

        private void setMaxBlocks(XpSource source) {
            String matName = this.originalBlock.getType().toString();
            if (source == null && matName.contains("STRIPPED")) {
                String[] woodNames;
                for (String woodName : woodNames = new String[]{"OAK", "SPRUCE", "BIRCH", "JUNGLE", "ACACIA", "DARK_OAK", "CRIMSON", "WARPED", "MANGROVE", "CHERRY"}) {
                    if (!matName.contains(woodName)) continue;
                    if (woodName.equals("CRIMSON") || woodName.equals("WARPED")) {
                        source = this.plugin.getSkillManager().getSourceById(NamespacedId.fromDefault(woodName.toLowerCase(Locale.ROOT) + "_stem"));
                        break;
                    }
                    source = this.plugin.getSkillManager().getSourceById(NamespacedId.fromDefault(woodName.toLowerCase(Locale.ROOT) + "_log"));
                    break;
                }
            }
            if (source != null) {
                if (matName.contains("OAK") || matName.contains("BIRCH") || matName.contains("ACACIA") || matName.contains("CHERRY")) {
                    this.maxBlocks = 100;
                } else if (matName.contains("SPRUCE") || matName.contains("CRIMSON") || matName.contains("WARPED") || matName.contains("MANGROVE")) {
                    this.maxBlocks = 125;
                } else if (matName.contains("JUNGLE")) {
                    this.maxBlocks = 220;
                } else if (matName.contains("DARK_OAK")) {
                    this.maxBlocks = 150;
                }
            } else {
                this.maxBlocks = 100;
            }
            double multiplier = ManaAbilities.TREECAPITATOR.optionDouble("max_blocks_multiplier", 1.0);
            this.maxBlocks = (int)((double)this.maxBlocks * multiplier);
        }
    }
}

