/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.foraging;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.AbilityImpl;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;

public class ForagingAbilities
extends AbilityImpl {
    public ForagingAbilities(AuraSkills plugin) {
        super(plugin, Abilities.LUMBERJACK, Abilities.FORAGER, Abilities.AXE_MASTER, Abilities.SHREDDER, Abilities.VALOR);
    }

    private DamageModifier axeMaster(Player player, User user) {
        Abilities ability = Abilities.AXE_MASTER;
        if (this.isDisabled(ability) || this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        return new DamageModifier(this.getValue(ability, user) / 100.0, DamageModifier.Operation.ADD_COMBINED);
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        if (attacker != null && meta.getDamageType() == DamageType.AXE) {
            User user = this.plugin.getUser(attacker);
            meta.addAttackModifier(this.axeMaster(attacker, user));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void shredder(PlayerItemDamageEvent event) {
        Abilities ability = Abilities.SHREDDER;
        if (this.isDisabled(ability)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!event.getPlayer().isOnline()) {
            return;
        }
        if (!ItemUtils.isArmor(event.getItem().getType())) {
            return;
        }
        EntityDamageEvent entityDamageEvent = event.getPlayer().getLastDamageCause();
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent e = (EntityDamageByEntityEvent)entityDamageEvent;
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.isOnline()) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (!e.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK)) {
            return;
        }
        Material mat = player.getInventory().getItemInMainHand().getType();
        boolean isAxe = false;
        switch (mat) {
            case NETHERITE_AXE: 
            case DIAMOND_AXE: 
            case IRON_AXE: 
            case GOLDEN_AXE: 
            case STONE_AXE: 
            case WOODEN_AXE: {
                isAxe = true;
            }
        }
        if (!isAxe) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (user.getAbilityLevel(ability) == 0) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            event.setDamage(event.getDamage() * 3);
        }
    }

    public void applyValor(User user) {
        Abilities ability = Abilities.VALOR;
        if (this.isDisabled(ability)) {
            return;
        }
        if (user.getAbilityLevel(ability) == 0) {
            return;
        }
        user.addStatModifier(new StatModifier("foraging-valor", Stats.STRENGTH, (double)((int)this.getValue(ability, user))));
    }

    public void removeValor(User user) {
        user.removeStatModifier("foraging-valor");
    }
}

