/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.fighting;

import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ReadiedManaAbility;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class LightningBlade
extends ReadiedManaAbility {
    private final UUID MODIFIER_ID = UUID.fromString("2fc64528-614b-11ee-8c99-0242ac120002");

    public LightningBlade(AuraSkills plugin) {
        super(plugin, ManaAbilities.LIGHTNING_BLADE, ManaAbilityMessage.LIGHTNING_BLADE_START, ManaAbilityMessage.LIGHTNING_BLADE_END, new String[]{"SWORD"}, new Action[]{Action.RIGHT_CLICK_AIR, Action.RIGHT_CLICK_BLOCK});
    }

    @Override
    public void onActivate(Player player, User user) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attribute == null) {
            return;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!modifier.getName().equals("auraskills_lightning_blade")) continue;
            attribute.removeModifier(modifier);
        }
        double addedValue = this.getValue(user) / 100.0;
        attribute.addModifier(new AttributeModifier(this.MODIFIER_ID, "auraskills_lightning_blade", addedValue, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 0.5f, 1.0f);
    }

    @Override
    public void onStop(Player player, User user) {
        user.removeTraitModifier("lightning_blade");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void activationListener(EntityDamageByEntityEvent event) {
        if (this.isDisabled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.failsChecks(player)) {
            return;
        }
        if (!this.isHoldingMaterial(player)) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK || cause == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (this.isActivated(user)) {
            return;
        }
        this.checkActivation(player);
    }

    @Override
    protected int getDuration(User user) {
        double baseDuration = this.manaAbility.optionDouble("base_duration", 5.0);
        double durationPerLevel = this.manaAbility.optionDouble("duration_per_level", 4.0);
        double durationSeconds = baseDuration + durationPerLevel * (double)(user.getManaAbilityLevel(this.manaAbility) - 1);
        return (int)Math.round(durationSeconds * 20.0);
    }

    @EventHandler
    public void lightningBladeJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isActivated(this.plugin.getUser(player))) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attribute == null) {
            return;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!modifier.getName().equals("AureliumSkills-LightningBlade")) continue;
            attribute.removeModifier(modifier);
        }
    }
}

