/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.fighting;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.AbilityImpl;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.common.ability.AbilityData;
import dev.aurelium.auraskills.common.message.type.AbilityMessage;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FightingAbilities
extends AbilityImpl {
    public static final String BLEED_DAMAGER_KEY = "bleed_damager";
    private final String PARRY_KEY = "parry_ready";
    private final String PARRY_VECTOR = "parry_vector";

    public FightingAbilities(AuraSkills plugin) {
        super(plugin, Abilities.PARRY, Abilities.FIGHTER, Abilities.SWORD_MASTER, Abilities.FIRST_STRIKE, Abilities.BLEED);
    }

    @Override
    public String replaceDescPlaceholders(String input, Ability ability, User user) {
        if (ability.equals(Abilities.BLEED)) {
            return TextUtil.replace(input, "{base_ticks}", String.valueOf(ability.optionInt("base_ticks", 3)), "{added_ticks}", String.valueOf(ability.optionInt("added_ticks", 2)));
        }
        if (ability.equals(Abilities.PARRY)) {
            String secDisplay = NumberUtil.format2((double)ability.optionInt("time_ms", 250) / 1000.0);
            return TextUtil.replace(input, "{time}", secDisplay);
        }
        return input;
    }

    private DamageModifier swordMaster(Player player, User user) {
        Abilities ability = Abilities.SWORD_MASTER;
        if (this.isDisabled(ability) || this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        return new DamageModifier(this.getValue(ability, user) / 100.0, DamageModifier.Operation.ADD_COMBINED);
    }

    private DamageModifier firstStrike(User user, Player player) {
        Abilities ability = Abilities.FIRST_STRIKE;
        if (this.isDisabled(ability) || this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (player.hasMetadata("AureliumSkills-FirstStrike")) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        Locale locale = user.getLocale();
        if (ability.optionBoolean("enable_message", true)) {
            this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(AbilityMessage.FIRST_STRIKE_DEALT, locale));
        }
        player.setMetadata("AureliumSkills-FirstStrike", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        AbilityData abilityData = user.getAbilityData(ability);
        if (abilityData.containsKey("counter")) {
            abilityData.setData("counter", abilityData.getInt("counter") + 1);
        } else {
            abilityData.setData("counter", 0);
        }
        int id = abilityData.getInt("counter");
        long cooldown = ability.optionInt("cooldown_ticks", 6000);
        this.plugin.getScheduler().scheduleSync(() -> {
            if (user.getAbilityData(ability).containsKey("counter") && user.getAbilityData(ability).getInt("counter") == id) {
                player.removeMetadata("AureliumSkills-FirstStrike", (Plugin)this.plugin);
            }
        }, cooldown * 50L, TimeUnit.MILLISECONDS);
        double modifier = this.getValue(ability, user) / 100.0;
        return new DamageModifier(modifier, DamageModifier.Operation.ADD_COMBINED);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void bleedListener(EntityDamageByEntityEvent event) {
        Abilities ability = Abilities.BLEED;
        if (this.isDisabled(ability)) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType().name().toUpperCase(Locale.ROOT).contains("SWORD")) {
            User user = this.plugin.getUser(player);
            if (event.getEntity() instanceof LivingEntity) {
                this.checkBleed(event, user, (LivingEntity)event.getEntity(), ability);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        Player target = meta.getTargetAsPlayer();
        if (attacker != null) {
            User user;
            if (meta.getDamageType() == DamageType.SWORD) {
                user = this.plugin.getUser(attacker);
                meta.addAttackModifier(this.swordMaster(attacker, user));
                meta.addAttackModifier(this.firstStrike(user, attacker));
            }
            if (target != null) {
                user = this.plugin.getUser(target);
                meta.addDefenseModifier(this.handleParry(event, target, user));
            }
        }
    }

    public void checkBleed(EntityDamageByEntityEvent event, User user, LivingEntity entity, Ability ability) {
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            NamespacedKey key;
            if (event.getFinalDamage() >= entity.getHealth()) {
                return;
            }
            PersistentDataContainer container = entity.getPersistentDataContainer();
            if (!container.has(key = new NamespacedKey((Plugin)this.plugin, "bleed_ticks"), PersistentDataType.INTEGER)) {
                int baseTicks = ability.optionInt("base_ticks", 3);
                container.set(key, PersistentDataType.INTEGER, (Object)baseTicks);
                if (ability.optionBoolean("enable_enemy_message", true)) {
                    Locale locale = user.getLocale();
                    Entity entity2 = event.getDamager();
                    if (entity2 instanceof Player) {
                        Player player = (Player)entity2;
                        this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(AbilityMessage.BLEED_ENEMY_BLEEDING, locale));
                    }
                }
                if (entity instanceof Player && ability.optionBoolean("enable_self_message", true)) {
                    Player player = (Player)entity;
                    Locale locale = user.getLocale();
                    this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(AbilityMessage.BLEED_SELF_BLEEDING, locale));
                }
                this.scheduleBleedTicks(entity, user, ability);
            } else {
                int maxTicks;
                int addedTicks;
                int currentTicks = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
                int resultingTicks = currentTicks + (addedTicks = ability.optionInt("added_ticks", 2));
                if (resultingTicks <= (maxTicks = ability.optionInt("max_ticks", 11))) {
                    container.set(key, PersistentDataType.INTEGER, (Object)resultingTicks);
                }
            }
        }
    }

    private void scheduleBleedTicks(final LivingEntity entity, final User user, final Ability ability) {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                NamespacedKey key;
                if (!entity.isValid()) {
                    this.cancel();
                    return;
                }
                PersistentDataContainer container = entity.getPersistentDataContainer();
                if (container.has(key = new NamespacedKey((Plugin)FightingAbilities.this.plugin, "bleed_ticks"), PersistentDataType.INTEGER)) {
                    int bleedTicks = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
                    if (bleedTicks > 0) {
                        double damage = ability.getSecondaryValue(user.getAbilityLevel(ability));
                        double healthBefore = entity.getHealth();
                        NamespacedKey damagerKey = new NamespacedKey((Plugin)FightingAbilities.this.plugin, FightingAbilities.BLEED_DAMAGER_KEY);
                        container.set(damagerKey, PersistentDataType.STRING, (Object)user.getUuid().toString());
                        entity.damage(damage);
                        entity.setNoDamageTicks(0);
                        container.remove(damagerKey);
                        double healthAfter = entity.getHealth();
                        if (healthAfter != healthBefore) {
                            FightingAbilities.this.displayBleedParticles(entity, ability);
                        }
                        if (bleedTicks != 1) {
                            container.set(key, PersistentDataType.INTEGER, (Object)(bleedTicks - 1));
                        } else {
                            container.remove(key);
                        }
                        return;
                    }
                    container.remove(key);
                }
                if (entity instanceof Player && ability.optionBoolean("enable_stop_message", true)) {
                    Player player = (Player)entity;
                    Locale locale = user.getLocale();
                    FightingAbilities.this.plugin.getAbilityManager().sendMessage(player, FightingAbilities.this.plugin.getMsg(AbilityMessage.BLEED_STOP, locale));
                }
                this.cancel();
            }
        };
        this.plugin.getScheduler().timerSync(task, 2000L, (long)ability.optionInt("tick_period", 40) * 50L, TimeUnit.MILLISECONDS);
    }

    private void displayBleedParticles(LivingEntity entity, Ability ability) {
        if (!ability.optionBoolean("show_particles", true)) {
            return;
        }
        Location location = entity.getLocation().add(0.0, entity.getHeight() * 0.6, 0.0);
        BlockData particleData = Material.REDSTONE_BLOCK.createBlockData();
        entity.getWorld().spawnParticle(CompatUtil.dustParticle(), location, 30, (Object)particleData);
    }

    @EventHandler
    public void onDeath(PlayerRespawnEvent event) {
        PersistentDataContainer container = event.getPlayer().getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "bleed_ticks");
        container.remove(key);
        container.remove(new NamespacedKey((Plugin)this.plugin, BLEED_DAMAGER_KEY));
    }

    @EventHandler
    public void parryReady(PlayerInteractEvent event) {
        Abilities ability = Abilities.PARRY;
        if (this.isDisabled(ability)) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.getInventory().getItemInMainHand().getType().toString().contains("SWORD")) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (user.metadataBoolean("parry_ready")) {
            return;
        }
        Vector facing = player.getLocation().getDirection();
        user.getMetadata().put("parry_ready", true);
        user.getMetadata().put("parry_vector", facing);
        this.scheduleUnready(user);
    }

    public DamageModifier handleParry(DamageEvent event, Player player, User user) {
        Abilities ability = Abilities.PARRY;
        if (this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (!user.metadataBoolean("parry_ready")) {
            return DamageModifier.none();
        }
        if (event.getDamageMeta().getAttacker() != null && !this.isFacingCloseEnough(user, player, event.getDamageMeta().getAttacker())) {
            return DamageModifier.none();
        }
        double value = this.getValue(ability, user);
        this.plugin.getUiProvider().sendActionBar(user, this.plugin.getMsg(AbilityMessage.PARRY_PARRIED, user.getLocale()));
        this.plugin.getUiProvider().getActionBarManager().setPaused(user, 1500, TimeUnit.MILLISECONDS);
        if (ability.optionBoolean("enable_sound", true)) {
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_TRIDENT_RETURN, SoundCategory.PLAYERS, 1.0f, 1.4f);
        }
        Vector velBefore = player.getVelocity();
        this.plugin.getScheduler().scheduleSync(() -> player.setVelocity(velBefore), 50L, TimeUnit.MILLISECONDS);
        return new DamageModifier(1.0 - value / 100.0 - 1.0, DamageModifier.Operation.MULTIPLY);
    }

    private boolean isFacingCloseEnough(User user, Player player, Entity damager) {
        Vector va = damager.getLocation().toVector();
        Vector vb = player.getLocation().toVector();
        Vector playerToDamager = va.subtract(vb).normalize();
        Object facingObj = user.getMetadata().get("parry_vector");
        if (facingObj == null) {
            return false;
        }
        Vector facing = (Vector)facingObj;
        return playerToDamager.dot(facing) >= 0.7;
    }

    private void scheduleUnready(User user) {
        this.plugin.getScheduler().scheduleSync(() -> {
            user.getMetadata().remove("parry_ready");
            user.getMetadata().remove("parry_vector");
        }, Abilities.PARRY.optionInt("time_ms", 250), TimeUnit.MILLISECONDS);
    }
}

