/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.farming;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.AbilityImpl;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;

public class FarmingAbilities
extends AbilityImpl {
    private final Random random = new Random();

    public FarmingAbilities(AuraSkills plugin) {
        super(plugin, Abilities.BOUNTIFUL_HARVEST, Abilities.FARMER, Abilities.GENETICIST, Abilities.SCYTHE_MASTER, Abilities.GROWTH_AURA);
    }

    @EventHandler
    public void geneticist(PlayerItemConsumeEvent event) {
        Abilities ability = Abilities.GENETICIST;
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, ability)) {
            return;
        }
        Material mat = event.getItem().getType();
        if (this.isPlantBased(mat)) {
            User user = this.plugin.getUser(player);
            float amount = (float)this.getValue(ability, user) / 10.0f;
            player.setSaturation(player.getSaturation() + amount);
        }
    }

    private boolean isPlantBased(Material mat) {
        return mat.equals((Object)Material.BREAD) || mat.equals((Object)Material.APPLE) || mat.equals((Object)Material.GOLDEN_APPLE) || mat.equals((Object)Material.POTATO) || mat.equals((Object)Material.BAKED_POTATO) || mat.equals((Object)Material.CARROT) || mat.equals((Object)Material.GOLDEN_CARROT) || mat.equals((Object)Material.MELON) || mat.equals((Object)Material.PUMPKIN_PIE) || mat.equals((Object)Material.BEETROOT) || mat.equals((Object)Material.BEETROOT_SOUP) || mat.equals((Object)Material.MUSHROOM_STEW) || mat.equals((Object)Material.POISONOUS_POTATO);
    }

    private DamageModifier scytheMaster(Player player, User user) {
        Abilities ability = Abilities.SCYTHE_MASTER;
        if (this.isDisabled(ability) || this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        return new DamageModifier(this.getValue(ability, user) / 100.0, DamageModifier.Operation.ADD_COMBINED);
    }

    @Override
    public String replaceDescPlaceholders(String input, Ability ability, User user) {
        if (ability.equals(Abilities.GROWTH_AURA)) {
            return TextUtil.replace(input, "{radius}", String.valueOf(ability.optionInt("radius", 30)));
        }
        return input;
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        if (attacker != null && meta.getDamageType() == DamageType.HOE) {
            User user = this.plugin.getUser(attacker);
            meta.addAttackModifier(this.scytheMaster(attacker, user));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onCropGrowth(BlockGrowEvent event) {
        Abilities ability = Abilities.GROWTH_AURA;
        if (this.isDisabled(ability)) {
            return;
        }
        Block block = event.getBlock();
        Location ogLoc = block.getLocation();
        int radius = ability.optionInt("radius", 30);
        Collection entities = block.getWorld().getNearbyEntities(ogLoc, (double)radius, (double)radius, (double)radius);
        List<Player> playerList = entities.stream().filter(e -> e instanceof Player).map(e -> (Player)e).toList();
        for (Player player : playerList) {
            this.handleGrowthAura(player, block, event.getNewState());
        }
    }

    private void handleGrowthAura(Player player, Block block, BlockState state) {
        Abilities ability = Abilities.GROWTH_AURA;
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        int extraStages = this.rollExtraStages(user);
        if (extraStages == 0) {
            return;
        }
        BlockData blockData = state.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            this.plugin.getScheduler().scheduleSync(() -> {
                if (block.getType() != state.getType()) {
                    return;
                }
                ageable.setAge(Math.min(ageable.getAge() + extraStages, ageable.getMaximumAge()));
                block.setBlockData((BlockData)ageable);
            }, 50L, TimeUnit.MILLISECONDS);
        }
    }

    private int rollExtraStages(User user) {
        double value = this.getValue(Abilities.GROWTH_AURA, user);
        int guaranteed = (int)(value / 100.0);
        double chance = (value - (double)(guaranteed * 100)) / 100.0;
        int extra = this.random.nextDouble() < chance ? 1 : 0;
        return guaranteed + extra;
    }
}

