/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.endurance;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.event.trait.CustomRegenEvent;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.AbilityImpl;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class EnduranceAbilities
extends AbilityImpl {
    public EnduranceAbilities(AuraSkills plugin) {
        super(plugin, Abilities.ANTI_HUNGER, Abilities.RUNNER, Abilities.GOLDEN_HEAL, Abilities.RECOVERY, Abilities.MEAL_STEAL);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void antiHunger(FoodLevelChangeEvent event) {
        Abilities ability = Abilities.ANTI_HUNGER;
        if (this.isDisabled(ability)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (player.getFoodLevel() <= event.getFoodLevel()) {
            return;
        }
        User user = this.plugin.getUser(player);
        double chance = this.getValue(ability, user) / 100.0;
        if (this.rand.nextDouble() < chance) {
            event.setFoodLevel(player.getFoodLevel());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void goldenHealAndRecovery(EntityRegainHealthEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        User user = this.plugin.getUser(player);
        if (event.getRegainReason().equals((Object)EntityRegainHealthEvent.RegainReason.MAGIC_REGEN)) {
            Abilities ability = Abilities.GOLDEN_HEAL;
            if (this.isDisabled(ability)) {
                return;
            }
            if (this.failsChecks(player, ability)) {
                return;
            }
            double modifier = this.getValue(ability, user) / 100.0;
            event.setAmount(event.getAmount() * (1.0 + modifier));
        } else if (event.getRegainReason().equals((Object)EntityRegainHealthEvent.RegainReason.SATIATED)) {
            double maxHealth;
            Abilities ability = Abilities.RECOVERY;
            if (this.isDisabled(ability)) {
                return;
            }
            if (this.failsChecks(player, ability)) {
                return;
            }
            AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attribute == null) {
                return;
            }
            double currentHealth = player.getHealth();
            if (currentHealth < (maxHealth = attribute.getValue()) / 2.0) {
                double modifier = this.getValue(ability, user) / 100.0;
                event.setAmount(event.getAmount() * (1.0 + modifier));
            }
        }
    }

    @EventHandler
    public void recoveryCustom(CustomRegenEvent event) {
        double maxHealth;
        Abilities ability = Abilities.RECOVERY;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = BukkitUser.getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        User user = this.plugin.getUser(player);
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        double currentHealth = player.getHealth();
        if (currentHealth < (maxHealth = attribute.getValue()) / 2.0) {
            double modifier = this.getValue(ability, user) / 100.0;
            event.setAmount(event.getAmount() * (1.0 + modifier));
        }
    }
}

