/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.archery;

import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ManaAbilityProvider;
import dev.aurelium.auraskills.common.ability.AbilityData;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ChargedShot
extends ManaAbilityProvider {
    public ChargedShot(AuraSkills plugin) {
        super(plugin, ManaAbilities.CHARGED_SHOT, ManaAbilityMessage.CHARGED_SHOT_SHOOT, null);
        this.tickChargedShotCooldown();
    }

    @Override
    public void onActivate(Player player, User user) {
        double manaConsumed = this.getManaCost(user);
        double damagePercent = manaConsumed * this.getValue(user);
        Object obj = user.getMetadata().get("charged_shot_projectile");
        if (!(obj instanceof Entity)) {
            return;
        }
        Entity projectile = (Entity)obj;
        projectile.setMetadata("ChargedShotMultiplier", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)(1.0 + damagePercent / 100.0)));
        if (this.manaAbility.optionBoolean("enable_sound", true)) {
            player.playSound(player.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, 0.5f, 1.0f);
        }
    }

    @Override
    public void onStop(Player player, User user) {
        user.getMetadata().remove("charged_shot_projectile");
        user.getMetadata().remove("charged_shot_force");
    }

    @EventHandler
    public void onToggle(PlayerInteractEvent event) {
        if (this.isDisabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player)) {
            return;
        }
        if (this.manaAbility.optionBoolean("always_enabled", false)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (item.getType() != Material.BOW) {
            return;
        }
        if (this.shouldIgnoreItem(item)) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
            User user = this.plugin.getUser(player);
            Locale locale = user.getLocale();
            AbilityData abilityData = user.getAbilityData(this.manaAbility);
            if (abilityData.getInt("toggle_cooldown") == 0) {
                if (!abilityData.getBoolean("enabled")) {
                    abilityData.setData("enabled", true);
                    this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(ManaAbilityMessage.CHARGED_SHOT_ENABLE, locale));
                } else {
                    abilityData.setData("enabled", false);
                    this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(ManaAbilityMessage.CHARGED_SHOT_DISABLE, locale));
                }
                abilityData.setData("toggle_cooldown", 8);
            }
        }
    }

    private void tickChargedShotCooldown() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (User user : ChargedShot.this.plugin.getUserManager().getOnlineUsers()) {
                    AbilityData abilityData = user.getAbilityData(ChargedShot.this.manaAbility);
                    int cooldown = abilityData.getInt("toggle_cooldown");
                    if (cooldown == 0) continue;
                    abilityData.setData("toggle_cooldown", cooldown - 1);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 150L, 250L, TimeUnit.MILLISECONDS);
    }

    @EventHandler
    public void activationListener(EntityShootBowEvent event) {
        if (this.isDisabled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.failsChecks(player)) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (!user.getAbilityData(this.manaAbility).getBoolean("enabled") && !this.manaAbility.optionBoolean("always_enabled", false)) {
            return;
        }
        ManaAbilityData data = user.getManaAbilityData(this.manaAbility);
        int cooldown = data.getCooldown();
        if (cooldown == 0) {
            user.getMetadata().put("charged_shot_projectile", event.getProjectile());
            user.getMetadata().put("charged_shot_force", Float.valueOf(event.getForce()));
            this.checkActivation(player);
        } else if (data.getErrorTimer() == 0) {
            Locale locale = user.getLocale();
            this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(ManaAbilityMessage.NOT_READY, locale), "{cooldown}", NumberUtil.format1((double)cooldown / 20.0)));
            data.setErrorTimer(2);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        if (attacker != null && meta.getDamageType() == DamageType.BOW) {
            meta.addAttackModifier(this.applyChargedShot((Entity)attacker));
        }
    }

    private DamageModifier applyChargedShot(Entity attacker) {
        if (!attacker.hasMetadata("ChargedShotMultiplier")) {
            return DamageModifier.none();
        }
        double multiplier = ((MetadataValue)attacker.getMetadata("ChargedShotMultiplier").get(0)).asDouble();
        return new DamageModifier(multiplier - 1.0, DamageModifier.Operation.ADD_COMBINED);
    }

    @Override
    protected void consumeMana(Player player, User user, double manaConsumed) {
        if (manaConsumed <= 0.0) {
            return;
        }
        double damagePercent = manaConsumed * this.manaAbility.getValue(user.getManaAbilityLevel(this.manaAbility));
        user.setMana(user.getMana() - manaConsumed);
        if (this.manaAbility.optionBoolean("enable_message", true)) {
            String manaStr = manaConsumed < 1.0 ? NumberUtil.format1(manaConsumed) : NumberUtil.format0(manaConsumed);
            String damagePercentStr = damagePercent < 1.0 ? NumberUtil.format1(damagePercent) : NumberUtil.format0(damagePercent);
            this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(this.getActivateMessage(), user.getLocale()), "{mana}", manaStr, "{percent}", damagePercentStr));
        }
    }

    @Override
    public double getManaCost(User user) {
        Object obj = user.getMetadata().get("charged_shot_force");
        float force = 0.0f;
        if (obj instanceof Float) {
            force = ((Float)obj).floatValue();
        }
        return Math.min(this.manaAbility.getManaCost(user.getManaAbilityLevel(this.manaAbility)) * (double)force, user.getMana());
    }

    @Override
    protected int getDuration(User user) {
        return 0;
    }
}

