/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.alchemy;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.AbilityImpl;
import dev.aurelium.auraskills.bukkit.item.BukkitPotionType;
import dev.aurelium.auraskills.bukkit.skills.agility.AgilityAbilities;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.bukkit.util.PotionUtil;
import dev.aurelium.auraskills.common.message.type.AbilityMessage;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class AlchemyAbilities
extends AbilityImpl {
    private final NamespacedKey DURATION_BONUS_KEY;

    public AlchemyAbilities(AuraSkills plugin) {
        super(plugin, Abilities.ALCHEMIST, Abilities.BREWER, Abilities.SPLASHER, Abilities.LINGERING, Abilities.WISE_EFFECT);
        this.DURATION_BONUS_KEY = new NamespacedKey((Plugin)plugin, "duration_bonus");
        this.wiseEffect();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void alchemist(BrewEvent event) {
        Abilities ability = Abilities.ALCHEMIST;
        if (this.isDisabled(ability)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!event.getBlock().hasMetadata("skillsBrewingStandOwner")) {
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(((MetadataValue)event.getBlock().getMetadata("skillsBrewingStandOwner").get(0)).asString()));
        if (!offlinePlayer.isOnline()) {
            return;
        }
        Player player = offlinePlayer.getPlayer();
        BrewerInventory inventory = event.getContents();
        if (player == null) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        this.updateBrewingStand(inventory, user, user.getLocale());
    }

    private void updateBrewingStand(BrewerInventory inventory, User user, Locale locale) {
        Abilities ability = Abilities.ALCHEMIST;
        this.plugin.getScheduler().scheduleSync(() -> {
            ItemStack[] contents = inventory.getContents();
            double multiplier = 1.0 + this.getValue(ability, user) / 100.0;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (item == null || !(item.getItemMeta() instanceof PotionMeta)) continue;
                contents[i] = this.applyDurationData(item, multiplier, locale);
            }
            inventory.setContents(contents);
        }, 50L, TimeUnit.MILLISECONDS);
    }

    private boolean isApplicablePotion(PotionType potionType) {
        switch (potionType) {
            case AWKWARD: 
            case MUNDANE: 
            case THICK: 
            case WATER: {
                return false;
            }
        }
        return switch (potionType.toString()) {
            case "HARMING", "HEALING", "STRONG_HARMING", "STRONG_HEALING", "INSTANT_DAMAGE", "INSTANT_HEAL" -> false;
            default -> true;
        };
    }

    private ItemStack applyDurationData(ItemStack item, double multiplier, Locale locale) {
        PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
        if (potionMeta == null) {
            return item;
        }
        BukkitPotionType bukkitPotionType = new BukkitPotionType(potionMeta);
        PotionType potionType = bukkitPotionType.getType();
        if (potionType != null && !this.isApplicablePotion(potionType)) {
            return item;
        }
        int originalDuration = PotionUtil.getDuration(bukkitPotionType);
        int duration = (int)((double)originalDuration * multiplier);
        int durationBonus = duration - originalDuration;
        ItemMeta meta = item.getItemMeta();
        if (duration == 0 || meta == null) {
            return item;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.DURATION_BONUS_KEY, PersistentDataType.INTEGER)) {
            return item;
        }
        container.set(this.DURATION_BONUS_KEY, PersistentDataType.INTEGER, (Object)durationBonus);
        if (Abilities.ALCHEMIST.optionBoolean("add_item_lore", true)) {
            List lore = meta.getLore() != null ? meta.getLore() : new ArrayList();
            lore.add(TextUtil.replace(this.plugin.getMsg(AbilityMessage.ALCHEMIST_LORE, locale), "{duration}", PotionUtil.formatDuration(durationBonus), "{value}", NumberUtil.format1((multiplier - 1.0) * 100.0)));
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrink(PlayerItemConsumeEvent event) {
        ItemMeta itemMeta;
        Abilities ability = Abilities.ALCHEMIST;
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (event.isCancelled()) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item.getType() != Material.POTION || !((itemMeta = item.getItemMeta()) instanceof PotionMeta)) {
            return;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        int durationBonus = (Integer)item.getItemMeta().getPersistentDataContainer().getOrDefault(this.DURATION_BONUS_KEY, PersistentDataType.INTEGER, (Object)0);
        if (durationBonus <= 0) {
            return;
        }
        BukkitPotionType bukkitPotionType = new BukkitPotionType(meta);
        PotionType potionType = bukkitPotionType.getType();
        if (potionType == null) {
            return;
        }
        PotionEffectType effectType = potionType.getEffectType();
        if (effectType != null) {
            int duration = PotionUtil.getDuration(bukkitPotionType);
            if (!potionType.toString().contains("TURTLE_MASTER")) {
                int amplifier = 0;
                if (bukkitPotionType.isUpgraded()) {
                    amplifier = potionType.equals((Object)PotionType.SLOWNESS) ? 3 : 1;
                }
                if (effectType.equals(PotionEffectType.SPEED) || CompatUtil.isEffect(effectType, Set.of("jump_boost", "jump"))) {
                    AgilityAbilities agilityAbilities = this.plugin.getAbilityManager().getAbilityImpl(AgilityAbilities.class);
                    PotionUtil.applyEffect(player, new PotionEffect(effectType, (int)((double)(duration + durationBonus) * agilityAbilities.getSugarRushSplashMultiplier(player)), amplifier));
                } else {
                    PotionUtil.applyEffect(player, new PotionEffect(effectType, duration + durationBonus, amplifier));
                }
            } else if (!bukkitPotionType.isUpgraded()) {
                PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.slowness(), duration + durationBonus, 3));
                PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.resistance(), duration + durationBonus, 2));
            } else {
                PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.slowness(), duration + durationBonus, 5));
                PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.resistance(), duration + durationBonus, 3));
            }
        }
        for (PotionEffect effect : meta.getCustomEffects()) {
            PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), effect.getDuration() + durationBonus, effect.getAmplifier()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSplash(PotionSplashEvent event) {
        PotionMeta meta;
        block17: {
            block16: {
                if (event.isCancelled()) {
                    return;
                }
                ItemStack item = event.getPotion().getItem();
                ItemMeta itemMeta = item.getItemMeta();
                if (!(itemMeta instanceof PotionMeta)) break block16;
                meta = (PotionMeta)itemMeta;
                if (item.getItemMeta() != null) break block17;
            }
            return;
        }
        BukkitPotionType bukkitPotionType = new BukkitPotionType(meta);
        PotionType potionType = bukkitPotionType.getType();
        if (potionType == null) {
            return;
        }
        if (meta.hasCustomEffects() && Skills.ALCHEMY.optionBoolean("ignore_custom_potions", false)) {
            return;
        }
        int durationBonus = 0;
        if (!this.isDisabled(Abilities.ALCHEMIST)) {
            ProjectileSource projectileSource = event.getPotion().getShooter();
            if (projectileSource instanceof Player) {
                Player player = (Player)projectileSource;
                if (!this.failsChecks(player, Abilities.ALCHEMIST)) {
                    durationBonus = (Integer)meta.getPersistentDataContainer().getOrDefault(this.DURATION_BONUS_KEY, PersistentDataType.INTEGER, (Object)0);
                }
            } else {
                durationBonus = (Integer)meta.getPersistentDataContainer().getOrDefault(this.DURATION_BONUS_KEY, PersistentDataType.INTEGER, (Object)0);
            }
        }
        for (PotionEffect effect : event.getPotion().getEffects()) {
            for (LivingEntity entity : event.getAffectedEntities()) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                double splasherMultiplier = this.getSplasherMultiplier(event.getPotion().getShooter(), event.getAffectedEntities());
                double intensity = event.getIntensity((LivingEntity)player);
                int duration = (int)((double)(PotionUtil.getDuration(bukkitPotionType) + durationBonus) * splasherMultiplier * intensity);
                if (!potionType.toString().contains("TURTLE_MASTER")) {
                    if (effect.getType().equals(PotionEffectType.SPEED) || CompatUtil.isEffect(effect.getType(), Set.of("jump_boost", "jump"))) {
                        AgilityAbilities agilityAbilities = this.plugin.getAbilityManager().getAbilityImpl(AgilityAbilities.class);
                        PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), (int)((double)duration * agilityAbilities.getSugarRushSplashMultiplier(player)), effect.getAmplifier()));
                        continue;
                    }
                    PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), duration, effect.getAmplifier()));
                    continue;
                }
                if (!bukkitPotionType.isUpgraded()) {
                    PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.slowness(), duration, 3));
                    PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.resistance(), duration, 2));
                    continue;
                }
                PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.slowness(), duration, 5));
                PotionUtil.applyEffect(player, new PotionEffect(CompatUtil.resistance(), duration, 3));
            }
        }
    }

    private double getSplasherMultiplier(ProjectileSource source, Collection<LivingEntity> affectedEntities) {
        Abilities ability = Abilities.SPLASHER;
        double splasherMultiplier = 1.0;
        if (source instanceof Player) {
            Player player = (Player)source;
            if (!this.isDisabled(ability) && !this.failsChecks(player, ability)) {
                User user = this.plugin.getUser(player);
                double splasherPercent = this.getValue(ability, user);
                int affectedPlayers = (int)affectedEntities.stream().filter(entity -> entity instanceof Player).filter(entity -> this.plugin.getUserManager().getUser(entity.getUniqueId()) != null).count();
                splasherMultiplier = 1.0 + splasherPercent / 100.0 * (double)affectedPlayers;
            }
        }
        return splasherMultiplier;
    }

    @EventHandler
    public void lingering(LingeringPotionSplashEvent event) {
        Abilities ability = Abilities.LINGERING;
        if (this.isDisabled(ability)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = null;
        if (event.getEntity().getShooter() instanceof Player) {
            player = (Player)event.getEntity().getShooter();
        }
        if (player == null) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        AreaEffectCloud cloud = event.getAreaEffectCloud();
        if (cloud.hasCustomEffects() && Skills.ALCHEMY.optionBoolean("ignore_custom_potions", false)) {
            return;
        }
        User user = this.plugin.getUser(player);
        double naturalDecay = 1.0 - this.getValue(ability, user) / 100.0;
        double entityDecay = 1.0 - this.getSecondaryValue(ability, user) / 100.0;
        if (naturalDecay <= 0.01) {
            naturalDecay = 0.01;
        }
        if (entityDecay <= 0.01) {
            entityDecay = 0.01;
        }
        cloud.setRadiusPerTick(cloud.getRadiusPerTick() * (float)naturalDecay);
        cloud.setRadiusOnUse(cloud.getRadiusOnUse() * (float)entityDecay);
    }

    private void wiseEffect() {
        final Abilities ability = Abilities.WISE_EFFECT;
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (AlchemyAbilities.this.isDisabled(ability)) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    User user = AlchemyAbilities.this.plugin.getUser(player);
                    if (!player.getActivePotionEffects().isEmpty()) {
                        if (AlchemyAbilities.this.failsChecks(player, ability)) continue;
                        HashSet<PotionEffectType> uniqueTypesSet = new HashSet<PotionEffectType>();
                        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                            uniqueTypesSet.add(potionEffect.getType());
                        }
                        int uniqueTypes = uniqueTypesSet.size();
                        double wisdomPerType = AlchemyAbilities.this.getValue(ability, user);
                        double modifierValue = wisdomPerType * (double)uniqueTypes;
                        if (!(modifierValue > 0.0)) continue;
                        StatModifier modifier = new StatModifier("AbilityModifier-WiseEffect", Stats.WISDOM, modifierValue);
                        user.addStatModifier(modifier, true);
                        continue;
                    }
                    user.removeStatModifier("AbilityModifier-WiseEffect", true);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 50L, 500L, TimeUnit.MILLISECONDS);
    }

    @EventHandler
    public void lifeSteal(EntityDeathEvent event) {
        boolean hostile;
        Abilities ability = Abilities.LIFE_STEAL;
        if (this.isDisabled(ability)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        boolean bl = hostile = entity instanceof Monster || entity instanceof Player || entity instanceof Phantom;
        if (!hostile) {
            return;
        }
        if (entity.getKiller() == null) {
            return;
        }
        Player player = entity.getKiller();
        if (player.equals(entity)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        AttributeInstance entityAttribute = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (entityAttribute == null) {
            return;
        }
        double maxHealth = entityAttribute.getValue();
        double percent = this.getValue(ability, user) / 100.0;
        double healthRegen = maxHealth * percent;
        AttributeInstance playerAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (playerAttribute == null) {
            return;
        }
        player.setHealth(player.getHealth() + Math.min(healthRegen, playerAttribute.getValue() - player.getHealth()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void goldenHeart(EntityDamageEvent event) {
        Abilities ability = Abilities.GOLDEN_HEART;
        if (this.isDisabled(ability)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (player.getAbsorptionAmount() <= 0.0) {
            return;
        }
        double multiplier = 1.0 - this.getValue(ability, user) / 100.0;
        if (multiplier < 0.01) {
            multiplier = 0.01;
        }
        event.setDamage(event.getDamage() * multiplier);
    }
}

