/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.scheduler;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.scheduler.BukkitTaskWrapper;
import dev.aurelium.auraskills.common.scheduler.Scheduler;
import dev.aurelium.auraskills.common.scheduler.Task;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BukkitScheduler
extends Scheduler {
    private final AuraSkills plugin;

    public BukkitScheduler(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Override
    public Task executeSync(Runnable runnable) {
        BukkitTask task = this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, runnable);
        return new BukkitTaskWrapper(task);
    }

    @Override
    public Task scheduleSync(Runnable runnable, long delay, TimeUnit timeUnit) {
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, runnable, timeUnit.toMillis(delay) / 50L);
        return new BukkitTaskWrapper(task);
    }

    @Override
    public Task timerSync(TaskRunnable runnable, long delay, long period, TimeUnit timeUnit) {
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)runnable, timeUnit.toMillis(delay) / 50L, timeUnit.toMillis(period) / 50L);
        BukkitTaskWrapper task = new BukkitTaskWrapper(bukkitTask);
        runnable.injectTask(task);
        return task;
    }

    @Override
    public Task timerAsync(TaskRunnable runnable, long delay, long period, TimeUnit timeUnit) {
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)runnable, timeUnit.toMillis(delay) / 50L, timeUnit.toMillis(period) / 50L);
        BukkitTaskWrapper task = new BukkitTaskWrapper(bukkitTask);
        runnable.injectTask(task);
        return task;
    }
}

