/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.reward;

import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.reward.RewardManager;
import dev.aurelium.auraskills.common.reward.RewardTable;
import dev.aurelium.auraskills.common.reward.SkillReward;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitRewardManager
extends RewardManager {
    public BukkitRewardManager(AuraSkillsPlugin plugin) {
        super(plugin);
    }

    @Override
    public void loadRewards() {
        this.rewardTables.clear();
        int patternsLoaded = 0;
        int levelsLoaded = 0;
        for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
            File rewardsDirectory = this.getRewardsDir(skill);
            File rewardsFile = new File(rewardsDirectory + "/" + skill.name().toLowerCase(Locale.ROOT) + ".yml");
            if (!rewardsFile.exists()) {
                if (skill instanceof CustomSkill) {
                    this.rewardTables.put(skill, new RewardTable(this.plugin));
                    continue;
                }
                try {
                    this.plugin.saveResource("rewards/" + skill.name().toLowerCase(Locale.ROOT) + ".yml", false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            YamlConfiguration rewardsConfig = YamlConfiguration.loadConfiguration((File)rewardsFile);
            RewardTable rewardTable = new RewardTable(this.plugin);
            patternsLoaded += this.loadPatterns(rewardTable, rewardsConfig.getMapList("patterns"), rewardsFile, skill.getMaxLevel());
            levelsLoaded += this.loadLevels(rewardTable, (FileConfiguration)rewardsConfig, rewardsFile);
            this.rewardTables.put(skill, rewardTable);
        }
        File globalFile = new File(this.plugin.getPluginFolder() + "/rewards/global.yml");
        if (!globalFile.exists()) {
            this.plugin.saveResource("rewards/global.yml", false);
        }
        YamlConfiguration globalConfig = YamlConfiguration.loadConfiguration((File)globalFile);
        RewardTable globalTable = new RewardTable(this.plugin);
        patternsLoaded += this.loadPatterns(globalTable, globalConfig.getMapList("patterns"), globalFile, this.plugin.config().getHighestMaxLevel());
        levelsLoaded += this.loadLevels(globalTable, (FileConfiguration)globalConfig, globalFile);
        for (Map.Entry<Integer, List<SkillReward>> entry : globalTable.getRewardsMap().entrySet()) {
            int level = entry.getKey();
            List<SkillReward> rewards = entry.getValue();
            for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
                RewardTable rewardTable = (RewardTable)this.rewardTables.get(skill);
                if (rewardTable == null) continue;
                for (SkillReward reward : rewards) {
                    rewardTable.addReward(reward, level);
                }
            }
        }
        this.plugin.logger().info("Loaded " + patternsLoaded + " pattern rewards and " + levelsLoaded + " level rewards");
    }

    private int loadLevels(RewardTable rewardTable, FileConfiguration rewardsConfig, File rewardsFile) {
        int levelsLoaded = 0;
        ConfigurationSection levelsSection = rewardsConfig.getConfigurationSection("levels");
        if (levelsSection == null) {
            return levelsLoaded;
        }
        for (String levelString : levelsSection.getKeys(false)) {
            try {
                int level = Integer.parseInt(levelString);
                List rewards = levelsSection.getMapList(levelString);
                for (int index = 0; index < rewards.size(); ++index) {
                    Map rewardMap = (Map)rewards.get(index);
                    try {
                        SkillReward reward = this.parseReward(rewardMap);
                        if (reward == null) continue;
                        rewardTable.addReward(reward, level);
                        ++levelsLoaded;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.logger().warn("Error while loading rewards file " + rewardsFile.getName() + " at path levels." + levelString + ".[" + index + "]: " + e.getMessage());
                    }
                }
            }
            catch (NumberFormatException e) {
                this.plugin.logger().warn("Error while loading rewards file " + rewardsFile.getName() + " at path levels." + levelString + ": Key " + levelString + " must be of type int");
            }
        }
        return levelsLoaded;
    }

    private File getRewardsDir(Skill skill) {
        if (skill instanceof CustomSkill) {
            CustomSkill customSkill = (CustomSkill)skill;
            NamespacedRegistry registry = this.plugin.getApi().getNamespacedRegistry(customSkill.getId().getNamespace());
            if (registry != null) {
                return new File(registry.getContentDirectory() + "/rewards");
            }
        }
        return new File(this.plugin.getPluginFolder() + "/rewards");
    }
}

