/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.requirement;

import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.requirement.GlobalRequirement;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class RequirementManager
implements Listener {
    private Set<GlobalRequirement> globalRequirements;
    private final Map<UUID, Integer> errorMessageTimer = new HashMap<UUID, Integer>();
    private final AuraSkills plugin;

    public RequirementManager(AuraSkills plugin) {
        this.plugin = plugin;
        this.load();
        this.tickTimer();
    }

    public void load() {
        FileConfiguration config = this.plugin.getConfig();
        this.globalRequirements = new HashSet<GlobalRequirement>();
        for (ModifierType type : ModifierType.values()) {
            List list = config.getStringList("requirement." + type.name().toLowerCase(Locale.ROOT) + ".global");
            for (String text : list) {
                String[] splitText = text.split(" ");
                Material material = Material.valueOf((String)splitText[0].toUpperCase(Locale.ROOT));
                HashMap<Skill, Integer> requirements = new HashMap<Skill, Integer>();
                for (int i = 1; i < splitText.length; ++i) {
                    String requirementText = splitText[i];
                    try {
                        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(requirementText.split(":")[0].toLowerCase(Locale.ROOT)));
                        if (skill == null) continue;
                        int level = Integer.parseInt(requirementText.split(":")[1]);
                        requirements.put(skill, level);
                        continue;
                    }
                    catch (Exception e) {
                        this.plugin.logger().warn("Error parsing global skill " + type.name().toLowerCase(Locale.ROOT) + " requirement skill level pair with text " + requirementText);
                    }
                }
                GlobalRequirement globalRequirement = new GlobalRequirement(type, material, requirements);
                this.globalRequirements.add(globalRequirement);
            }
        }
    }

    public Set<GlobalRequirement> getGlobalRequirements() {
        return this.globalRequirements;
    }

    public Set<GlobalRequirement> getGlobalRequirementsType(ModifierType type) {
        HashSet<GlobalRequirement> matched = new HashSet<GlobalRequirement>();
        for (GlobalRequirement requirement : this.globalRequirements) {
            if (requirement.getType() != type) continue;
            matched.add(requirement);
        }
        return matched;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.errorMessageTimer.remove(event.getPlayer().getUniqueId());
    }

    public void tickTimer() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (UUID id : RequirementManager.this.errorMessageTimer.keySet()) {
                    int timer = RequirementManager.this.errorMessageTimer.get(id);
                    if (timer == 0) continue;
                    RequirementManager.this.errorMessageTimer.put(id, RequirementManager.this.errorMessageTimer.get(id) - 1);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public Map<UUID, Integer> getErrorMessageTimer() {
        return this.errorMessageTimer;
    }
}

