/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.region;

import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardHook;
import dev.aurelium.auraskills.bukkit.region.BukkitRegionManager;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.bukkit.util.BlockFaceUtil;
import dev.aurelium.auraskills.common.config.Option;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RegionBlockListener
implements Listener {
    private final AuraSkills plugin;
    private final BukkitRegionManager regionManager;
    private final BlockLeveler blockLeveler;

    public RegionBlockListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.regionManager = plugin.getRegionManager();
        this.blockLeveler = plugin.getLevelManager().getLeveler(BlockLeveler.class);
    }

    @EventHandler
    public void checkPlace(BlockPlaceEvent event) {
        if (this.plugin.getWorldManager().isCheckReplaceDisabled(event.getBlock().getLocation())) {
            return;
        }
        if (this.plugin.getHookManager().isRegistered(WorldGuardHook.class) && this.plugin.getHookManager().getHook(WorldGuardHook.class).isInBlockedCheckRegion(event.getBlock().getLocation())) {
            return;
        }
        if (!this.plugin.configBoolean(Option.CHECK_BLOCK_REPLACE_ENABLED)) {
            return;
        }
        Block block = event.getBlock();
        SkillSource<BlockXpSource> skillSource = this.blockLeveler.getSource(block, BlockXpSource.BlockTriggers.BREAK);
        if (skillSource == null) {
            return;
        }
        BlockXpSource source = skillSource.source();
        if (!source.checkReplace()) {
            return;
        }
        this.regionManager.addPlacedBlock(block);
    }

    @EventHandler
    public void onSandFall(EntityChangeBlockEvent event) {
        Block below;
        Block block = event.getBlock();
        if (!this.regionManager.isPlacedBlock(block)) {
            return;
        }
        final Material type = block.getType();
        if (!(type != Material.SAND && type != Material.RED_SAND && type != Material.GRAVEL || (below = block.getRelative(BlockFace.DOWN)).getType() != Material.AIR && below.getType() != Material.CAVE_AIR && below.getType() != Material.VOID_AIR && below.getType() != Material.WATER && below.getType() != Material.BUBBLE_COLUMN && below.getType() != Material.LAVA)) {
            this.regionManager.removePlacedBlock(block);
            final Entity entity = event.getEntity();
            final AtomicInteger counter = new AtomicInteger();
            new BukkitRunnable(){

                public void run() {
                    Block currentBlock = entity.getLocation().getBlock();
                    if (entity.isDead() || !entity.isValid()) {
                        if (currentBlock.getType() == type) {
                            RegionBlockListener.this.regionManager.addPlacedBlock(entity.getLocation().getBlock());
                        }
                        this.cancel();
                    } else if (currentBlock.getType().toString().contains("WEB")) {
                        this.cancel();
                    } else if (counter.incrementAndGet() >= 200) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void checkBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        this.regionManager.removePlacedBlock(block);
        this.checkTallPlant(block, 0, mat -> mat == Material.SUGAR_CANE);
        this.checkTallPlant(block, 0, mat -> mat == Material.BAMBOO);
        this.checkTallPlant(block, 0, mat -> mat == Material.CACTUS);
        this.checkSupportBelow(block);
        this.checkSupportSide(block);
    }

    @EventHandler
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            this.regionManager.addPlacedBlock(block.getRelative(event.getDirection()));
        }
        this.regionManager.removePlacedBlock(event.getBlock().getRelative(event.getDirection()));
    }

    @EventHandler
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block lastBlock = event.getBlock();
        for (Block block : event.getBlocks()) {
            if (!this.regionManager.isPlacedBlock(block)) continue;
            this.regionManager.addPlacedBlock(block.getRelative(event.getDirection()));
            if (!(block.getLocation().distanceSquared(event.getBlock().getLocation()) > lastBlock.getLocation().distanceSquared(event.getBlock().getLocation()))) continue;
            lastBlock = block;
        }
        this.regionManager.removePlacedBlock(lastBlock);
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        int growY = event.getLocation().getBlockY();
        for (BlockState state : event.getBlocks()) {
            if (state.getLocation().getY() != (double)growY) continue;
            this.regionManager.removePlacedBlock(state.getBlock());
        }
    }

    private void checkTallPlant(Block block, int num, Predicate<Material> isMaterial) {
        Block above;
        if (num < 20 && isMaterial.test((above = block.getRelative(BlockFace.UP)).getType()) && this.regionManager.isPlacedBlock(above)) {
            this.regionManager.removePlacedBlock(above);
            this.checkTallPlant(above, num + 1, isMaterial);
        }
    }

    private void checkSupportBelow(final Block block) {
        BlockXpSource source;
        final Block above = block.getRelative(BlockFace.UP);
        SkillSource<BlockXpSource> skillSource = this.blockLeveler.getSource(block, BlockXpSource.BlockTriggers.BREAK);
        BlockXpSource blockXpSource = source = skillSource == null ? null : skillSource.source();
        if (source != null && source.requiresSupportBlock(BlockXpSource.SupportBlockType.BELOW) && this.regionManager.isPlacedBlock(above)) {
            new BukkitRunnable(){

                public void run() {
                    if (RegionBlockListener.this.blockLeveler.isDifferentSource(block, source, BlockXpSource.BlockTriggers.BREAK)) {
                        RegionBlockListener.this.regionManager.removePlacedBlock(above);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private void checkSupportSide(final Block block) {
        for (BlockFace face : BlockFaceUtil.getBlockSides()) {
            BlockXpSource source;
            Block checkedBlock = block.getRelative(face);
            SkillSource<BlockXpSource> skillSource = this.blockLeveler.getSource(block, BlockXpSource.BlockTriggers.BREAK);
            BlockXpSource blockXpSource = source = skillSource == null ? null : skillSource.source();
            if (source == null || !source.requiresSupportBlock(BlockXpSource.SupportBlockType.SIDE) || !this.regionManager.isPlacedBlock(checkedBlock)) continue;
            new BukkitRunnable(){

                public void run() {
                    if (RegionBlockListener.this.blockLeveler.isDifferentSource(block, source, BlockXpSource.BlockTriggers.BREAK)) {
                        RegionBlockListener.this.regionManager.removePlacedBlock(block);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }
}

