/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.region;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.region.WorldManager;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class BukkitWorldManager
implements WorldManager {
    private List<String> blockedWorlds;
    private List<String> disabledWorlds;
    private List<String> blockedCheckBlockReplaceWorlds;
    private final AuraSkills plugin;

    public BukkitWorldManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void loadWorlds(FileConfiguration config) {
        int blockedWorldsLoaded = 0;
        this.blockedWorlds = new LinkedList<String>();
        this.disabledWorlds = new LinkedList<String>();
        this.blockedCheckBlockReplaceWorlds = new LinkedList<String>();
        for (String blockedWorld : config.getStringList("blocked_worlds")) {
            this.blockedWorlds.add(blockedWorld);
            ++blockedWorldsLoaded;
        }
        for (String blockedWorld : config.getStringList("disabled_worlds")) {
            this.disabledWorlds.add(blockedWorld);
            ++blockedWorldsLoaded;
        }
        for (String blockedWorld : config.getStringList("check_block_replace.blocked_worlds")) {
            this.blockedCheckBlockReplaceWorlds.add(blockedWorld);
            ++blockedWorldsLoaded;
        }
        this.plugin.logger().info("Loaded " + blockedWorldsLoaded + " blocked worlds.");
    }

    public boolean isInBlockedWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.disabledWorlds.contains(world.getName()) || this.blockedWorlds.contains(world.getName());
    }

    public boolean isInDisabledWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.disabledWorlds.contains(world.getName());
    }

    public boolean isCheckReplaceDisabled(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.blockedCheckBlockReplaceWorlds.contains(world.getName());
    }

    @Override
    public boolean isBlockedWorld(String worldName) {
        return this.blockedWorlds.contains(worldName);
    }

    @Override
    public boolean isDisabledWorld(String worldName) {
        return this.disabledWorlds.contains(worldName);
    }
}

