/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.region;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.region.BlockPosition;
import dev.aurelium.auraskills.common.region.ChunkCoordinate;
import dev.aurelium.auraskills.common.region.ChunkData;
import dev.aurelium.auraskills.common.region.Region;
import dev.aurelium.auraskills.common.region.RegionCoordinate;
import dev.aurelium.auraskills.common.region.RegionManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class BukkitRegionManager
extends RegionManager {
    public BukkitRegionManager(AuraSkills plugin) {
        super(plugin);
    }

    public boolean isPlacedBlock(Block block) {
        byte regionChunkZ;
        byte regionChunkX;
        ChunkData chunkData;
        int chunkX = block.getChunk().getX();
        int chunkZ = block.getChunk().getZ();
        int regionX = (int)Math.floor((double)chunkX / 32.0);
        int regionZ = (int)Math.floor((double)chunkZ / 32.0);
        Region region = (Region)this.regions.get(new RegionCoordinate(block.getWorld().getName(), regionX, regionZ));
        if (region != null && (chunkData = region.getChunkData(new ChunkCoordinate(regionChunkX = (byte)(chunkX - regionX * 32), regionChunkZ = (byte)(chunkZ - regionZ * 32)))) != null) {
            BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
            return chunkData.isPlacedBlock(blockPosition);
        }
        return false;
    }

    public void addPlacedBlock(Block block) {
        Region region = this.getRegionFromBlock(block);
        if (region == null) {
            int regionX = (int)Math.floor((double)block.getChunk().getX() / 32.0);
            int regionZ = (int)Math.floor((double)block.getChunk().getZ() / 32.0);
            region = new Region(block.getWorld().getName(), regionX, regionZ);
            RegionCoordinate regionCoordinate = new RegionCoordinate(block.getWorld().getName(), regionX, regionZ);
            this.regions.put(regionCoordinate, region);
            this.loadRegion(region);
        } else if (region.shouldReload()) {
            this.loadRegion(region);
        }
        byte regionChunkX = (byte)(block.getChunk().getX() - region.getX() * 32);
        byte regionChunkZ = (byte)(block.getChunk().getZ() - region.getZ() * 32);
        ChunkData chunkData = region.getChunkData(new ChunkCoordinate(regionChunkX, regionChunkZ));
        if (chunkData == null) {
            chunkData = new ChunkData(region, regionChunkX, regionChunkZ);
            region.setChunkData(new ChunkCoordinate(regionChunkX, regionChunkZ), chunkData);
        }
        chunkData.addPlacedBlock(new BlockPosition(block.getX(), block.getY(), block.getZ()));
    }

    public void removePlacedBlock(Block block) {
        byte regionChunkZ;
        byte regionChunkX;
        ChunkData chunkData;
        Region region = this.getRegionFromBlock(block);
        if (region != null && (chunkData = region.getChunkData(new ChunkCoordinate(regionChunkX = (byte)(block.getChunk().getX() - region.getX() * 32), regionChunkZ = (byte)(block.getChunk().getZ() - region.getZ() * 32)))) != null) {
            chunkData.removePlacedBlock(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        }
    }

    @Nullable
    private Region getRegionFromBlock(Block block) {
        int chunkX = block.getChunk().getX();
        int chunkZ = block.getChunk().getZ();
        int regionX = (int)Math.floor((double)chunkX / 32.0);
        int regionZ = (int)Math.floor((double)chunkZ / 32.0);
        RegionCoordinate regionCoordinate = new RegionCoordinate(block.getWorld().getName(), regionX, regionZ);
        return (Region)this.regions.get(regionCoordinate);
    }

    @Override
    public boolean isChunkLoaded(String worldName, int chunkX, int chunkZ) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return false;
        }
        return world.isChunkLoaded(chunkX, chunkZ);
    }
}

