/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.modifier;

import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.nbtapi.NBTCompound;
import dev.aurelium.auraskills.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Multipliers {
    private final AuraSkills plugin;

    public Multipliers(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public List<Multiplier> getLegacyMultipliers(ModifierType type, NBTItem nbtItem) {
        NBTCompound legacyCompound = ItemUtils.getLegacyMultipliersTypeCompound(nbtItem, type);
        ArrayList<Multiplier> multipliers = new ArrayList<Multiplier>();
        for (String key : legacyCompound.getKeys()) {
            double value = legacyCompound.getDouble(key);
            if (key.equals("Global")) {
                multipliers.add(new Multiplier(key, null, value));
                continue;
            }
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(key.toLowerCase(Locale.ROOT)));
            if (skill == null) continue;
            multipliers.add(new Multiplier(key, skill, value));
        }
        return multipliers;
    }
}

