/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.modifier;

import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class ModifierManager {
    private final AuraSkills plugin;

    public ModifierManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void reloadPlayer(Player player) {
        EntityEquipment equipment;
        ItemStack itemOffHand;
        User user = this.plugin.getUser(player);
        HashSet<Stat> statsToReload = new HashSet<Stat>();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.AIR) {
            SkillsItem skillsItem = new SkillsItem(item, this.plugin);
            for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                user.removeStatModifier(modifier.name());
                statsToReload.add(modifier.stat());
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                user.removeMultiplier(multiplier.name());
            }
            if (skillsItem.meetsRequirements(ModifierType.ITEM, player)) {
                for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                    user.addStatModifier(modifier, false);
                    statsToReload.add(modifier.stat());
                }
                for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                    user.addMultiplier(multiplier);
                }
            }
        }
        if ((itemOffHand = player.getInventory().getItemInOffHand()).getType() != Material.AIR) {
            SkillsItem skillsItem = new SkillsItem(itemOffHand, this.plugin);
            for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                user.removeStatModifier(modifier.name() + ".Offhand");
                statsToReload.add(modifier.stat());
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                user.removeMultiplier(multiplier.name() + ".Offhand");
            }
            if (skillsItem.meetsRequirements(ModifierType.ITEM, player)) {
                for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                    StatModifier offHandModifier = new StatModifier(modifier.name() + ".Offhand", modifier.stat(), modifier.value());
                    user.addStatModifier(offHandModifier, false);
                    statsToReload.add(modifier.stat());
                }
                for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                    Multiplier offHandMultiplier = new Multiplier(multiplier.name() + ".Offhand", multiplier.skill(), multiplier.value());
                    user.addMultiplier(offHandMultiplier);
                }
            }
        }
        if ((equipment = player.getEquipment()) != null) {
            for (ItemStack armor : equipment.getArmorContents()) {
                if (armor == null || armor.getType() == Material.AIR) continue;
                SkillsItem skillsItem = new SkillsItem(armor, this.plugin);
                for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                    user.removeStatModifier(modifier.name());
                    statsToReload.add(modifier.stat());
                }
                for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                    user.removeMultiplier(multiplier.name());
                }
                if (!skillsItem.meetsRequirements(ModifierType.ARMOR, player)) continue;
                for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                    user.addStatModifier(modifier, false);
                    statsToReload.add(modifier.stat());
                }
                for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                    user.addMultiplier(multiplier);
                }
            }
        }
        for (Stat stat : statsToReload) {
            this.plugin.getStatManager().reloadStat(user, stat);
        }
    }
}

