/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.modifier;

import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.skills.foraging.ForagingAbilities;
import dev.aurelium.auraskills.bukkit.skills.mining.MiningAbilities;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.stat.StatManager;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.nbtapi.NBTItem;
import dev.aurelium.auraskills.nbtapi.NBTType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public class ItemListener
implements Listener {
    private final AuraSkills plugin;
    private final Map<UUID, ItemStack> heldItems;
    private final Map<UUID, ItemStack> offHandItems;
    private final StatManager statManager;
    private final ForagingAbilities foragingAbilities;
    private final MiningAbilities miningAbilities;

    public ItemListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.heldItems = new HashMap<UUID, ItemStack>();
        this.offHandItems = new HashMap<UUID, ItemStack>();
        this.statManager = plugin.getStatManager();
        this.foragingAbilities = plugin.getAbilityManager().getAbilityImpl(ForagingAbilities.class);
        this.miningAbilities = plugin.getAbilityManager().getAbilityImpl(MiningAbilities.class);
        this.scheduleTask();
    }

    @EventHandler
    public void onJoin(UserLoadEvent event) {
        Player player = event.getPlayer();
        BukkitUser user = BukkitUser.getUser(event.getUser());
        ArrayList<String> toRemove = new ArrayList<String>();
        for (StatModifier modifier : user.getStatModifiers().values()) {
            if (!modifier.name().startsWith("AureliumSkills.Modifier")) continue;
            toRemove.add(modifier.name());
        }
        toRemove.forEach(user::removeStatModifier);
        ItemStack held = player.getInventory().getItemInMainHand();
        this.heldItems.put(player.getUniqueId(), held.clone());
        if (!held.getType().equals((Object)Material.AIR)) {
            if (this.plugin.configBoolean(Option.MODIFIER_AUTO_CONVERT_FROM_LEGACY) && !(held = this.convertLegacyItem(held)).equals((Object)player.getInventory().getItemInMainHand())) {
                player.getInventory().setItemInMainHand(held);
            }
            SkillsItem skillsItem = new SkillsItem(held, this.plugin);
            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                user.addStatModifier(statModifier, false);
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
                user.addTraitModifier(traitModifier, false);
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                user.addMultiplier(multiplier);
            }
        }
        if (this.plugin.configBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
            ItemStack offHandItem = player.getInventory().getItemInOffHand();
            this.offHandItems.put(player.getUniqueId(), offHandItem.clone());
            if (!offHandItem.getType().equals((Object)Material.AIR)) {
                if (this.plugin.configBoolean(Option.MODIFIER_AUTO_CONVERT_FROM_LEGACY) && !(offHandItem = this.convertLegacyItem(offHandItem)).equals((Object)player.getInventory().getItemInOffHand())) {
                    player.getInventory().setItemInOffHand(offHandItem);
                }
                this.applyOffhandModifiers(offHandItem, user);
            }
        }
    }

    private ItemStack convertLegacyItem(ItemStack item) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.convertFromLegacy();
        item = skillsItem.getItem();
        NBTItem nbtItem = new NBTItem(item);
        if (nbtItem.hasTag("AureliumSkills", NBTType.NBTTagCompound)) {
            nbtItem.removeKey("AureliumSkills");
            item = nbtItem.getItem();
        }
        return item;
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.heldItems.remove(player.getUniqueId());
        this.offHandItems.remove(player.getUniqueId());
    }

    public void scheduleTask() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    User user;
                    ItemStack held;
                    ItemStack finalHeld = held = player.getInventory().getItemInMainHand();
                    ItemStack stored = ItemListener.this.heldItems.computeIfAbsent(player.getUniqueId(), id -> finalHeld.clone());
                    if (stored.equals((Object)held)) continue;
                    HashSet<Stat> statsToReload = new HashSet<Stat>();
                    HashSet<Trait> traitsToReload = new HashSet<Trait>();
                    if (!stored.getType().equals((Object)Material.AIR)) {
                        user = ItemListener.this.plugin.getUser(player);
                        SkillsItem storedItem = new SkillsItem(stored, ItemListener.this.plugin);
                        for (StatModifier statModifier : storedItem.getStatModifiers(ModifierType.ITEM)) {
                            user.removeStatModifier(statModifier.name(), false);
                            statsToReload.add(statModifier.stat());
                        }
                        for (TraitModifier traitModifier : storedItem.getTraitModifiers(ModifierType.ITEM)) {
                            user.removeTraitModifier(traitModifier.name(), false);
                            traitsToReload.add(traitModifier.trait());
                        }
                        for (Multiplier multiplier : storedItem.getMultipliers(ModifierType.ITEM)) {
                            user.removeMultiplier(multiplier.name());
                        }
                        if (ItemUtils.isAxe(stored.getType())) {
                            ItemListener.this.foragingAbilities.removeValor(user);
                        }
                        if (ItemUtils.isPickaxe(stored.getType())) {
                            ItemListener.this.miningAbilities.removeStamina(user);
                        }
                    }
                    if (!held.getType().equals((Object)Material.AIR)) {
                        if (ItemListener.this.plugin.configBoolean(Option.MODIFIER_AUTO_CONVERT_FROM_LEGACY) && !(held = ItemListener.this.convertLegacyItem(held)).equals((Object)player.getInventory().getItemInMainHand())) {
                            player.getInventory().setItemInMainHand(held);
                        }
                        user = ItemListener.this.plugin.getUser(player);
                        SkillsItem heldItem = new SkillsItem(held, ItemListener.this.plugin);
                        if (heldItem.meetsRequirements(ModifierType.ITEM, player)) {
                            for (StatModifier statModifier : heldItem.getStatModifiers(ModifierType.ITEM)) {
                                user.addStatModifier(statModifier, false);
                                statsToReload.add(statModifier.stat());
                            }
                            for (TraitModifier traitModifier : heldItem.getTraitModifiers(ModifierType.ITEM)) {
                                user.addTraitModifier(traitModifier, false);
                                traitsToReload.add(traitModifier.trait());
                            }
                            for (Multiplier multiplier : heldItem.getMultipliers(ModifierType.ITEM)) {
                                user.addMultiplier(multiplier);
                            }
                        }
                        if (ItemUtils.isAxe(held.getType())) {
                            ItemListener.this.foragingAbilities.applyValor(user);
                        }
                        if (ItemUtils.isPickaxe(held.getType())) {
                            ItemListener.this.miningAbilities.applyStamina(player, user);
                        }
                    }
                    for (Stat stat : statsToReload) {
                        ItemListener.this.statManager.reloadStat(ItemListener.this.plugin.getUser(player), stat);
                    }
                    for (Trait trait : traitsToReload) {
                        ItemListener.this.statManager.reload(ItemListener.this.plugin.getUser(player), trait);
                    }
                    ItemListener.this.heldItems.put(player.getUniqueId(), held.clone());
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_ITEM_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
        this.scheduleOffHandTask();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSwap(PlayerSwapHandItemsEvent event) {
        boolean meetsRequirements;
        SkillsItem skillsItem;
        if (event.isCancelled()) {
            return;
        }
        if (!this.plugin.configBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        User playerData = this.plugin.getUser(player);
        ItemStack itemOffHand = event.getOffHandItem();
        ItemStack itemMainHand = event.getMainHandItem();
        this.offHandItems.put(player.getUniqueId(), itemOffHand);
        this.heldItems.put(player.getUniqueId(), itemMainHand);
        HashSet<String> offHandModifiers = new HashSet<String>();
        HashSet<Stat> statsToReload = new HashSet<Stat>();
        HashSet<Trait> traitsToReload = new HashSet<Trait>();
        HashSet<String> offHandMultipliers = new HashSet<String>();
        if (itemOffHand != null && itemOffHand.getType() != Material.AIR) {
            AuraSkillsModifier offHandModifier;
            skillsItem = new SkillsItem(itemOffHand, this.plugin);
            meetsRequirements = skillsItem.meetsRequirements(ModifierType.ITEM, player);
            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                offHandModifier = new StatModifier(statModifier.name() + ".Offhand", statModifier.stat(), statModifier.value());
                playerData.removeStatModifier(statModifier.name(), false);
                if (meetsRequirements) {
                    playerData.addStatModifier((StatModifier)offHandModifier, false);
                }
                offHandModifiers.add(offHandModifier.name());
                statsToReload.add(statModifier.stat());
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
                offHandModifier = new TraitModifier(traitModifier.name() + ".Offhand", traitModifier.trait(), traitModifier.value());
                playerData.removeTraitModifier(traitModifier.name(), false);
                if (meetsRequirements) {
                    playerData.addTraitModifier((TraitModifier)offHandModifier, false);
                }
                offHandModifiers.add(offHandModifier.name());
                traitsToReload.add(traitModifier.trait());
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                Multiplier offHandMultiplier = new Multiplier(multiplier.name() + ".Offhand", multiplier.skill(), multiplier.value());
                playerData.removeMultiplier(multiplier.name());
                if (meetsRequirements) {
                    playerData.addMultiplier(offHandMultiplier);
                }
                offHandMultipliers.add(offHandMultiplier.name());
            }
        }
        if (itemMainHand != null && itemMainHand.getType() != Material.AIR) {
            skillsItem = new SkillsItem(itemMainHand, this.plugin);
            meetsRequirements = skillsItem.meetsRequirements(ModifierType.ITEM, player);
            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
                if (!offHandModifiers.contains(statModifier.name() + ".Offhand")) {
                    playerData.removeStatModifier(statModifier.name() + ".Offhand", false);
                }
                if (meetsRequirements) {
                    playerData.addStatModifier(statModifier, false);
                }
                statsToReload.add(statModifier.stat());
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
                if (!offHandModifiers.contains(traitModifier.name() + ".Offhand")) {
                    playerData.removeTraitModifier(traitModifier.name() + ".Offhand", false);
                }
                if (meetsRequirements) {
                    playerData.addTraitModifier(traitModifier, false);
                }
                traitsToReload.add(traitModifier.trait());
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                if (!offHandMultipliers.contains(multiplier.name() + ".Offhand")) {
                    playerData.removeMultiplier(multiplier.name() + ".Offhand");
                }
                if (!meetsRequirements) continue;
                playerData.addMultiplier(multiplier);
            }
        }
        for (Stat stat : statsToReload) {
            this.statManager.reloadStat(this.plugin.getUser(player), stat);
        }
        for (Trait trait : traitsToReload) {
            this.statManager.reload(this.plugin.getUser(player), trait);
        }
    }

    public void scheduleOffHandTask() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (!ItemListener.this.plugin.configBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SkillsItem heldItem;
                    ItemStack held = player.getInventory().getItemInOffHand();
                    ItemStack stored = ItemListener.this.offHandItems.computeIfAbsent(player.getUniqueId(), id -> held.clone());
                    if (stored.equals((Object)held)) continue;
                    if (!stored.getType().equals((Object)Material.AIR)) {
                        User playerData = ItemListener.this.plugin.getUser(player);
                        SkillsItem storedItem = new SkillsItem(stored, ItemListener.this.plugin);
                        for (StatModifier statModifier : storedItem.getStatModifiers(ModifierType.ITEM)) {
                            playerData.removeStatModifier(statModifier.name() + ".Offhand");
                        }
                        for (TraitModifier traitModifier : storedItem.getTraitModifiers(ModifierType.ITEM)) {
                            playerData.removeTraitModifier(traitModifier.name() + ".Offhand");
                        }
                        for (Multiplier multiplier : storedItem.getMultipliers(ModifierType.ITEM)) {
                            playerData.removeMultiplier(multiplier.name() + ".Offhand");
                        }
                    }
                    if (!held.getType().equals((Object)Material.AIR) && (heldItem = new SkillsItem(held, ItemListener.this.plugin)).meetsRequirements(ModifierType.ITEM, player)) {
                        ItemListener.this.applyOffhandModifiers(held, ItemListener.this.plugin.getUser(player));
                    }
                    ItemListener.this.offHandItems.put(player.getUniqueId(), held.clone());
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_ITEM_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
    }

    private void applyOffhandModifiers(ItemStack held, User user) {
        AuraSkillsModifier offHandModifier;
        SkillsItem skillsItem = new SkillsItem(held, this.plugin);
        for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
            offHandModifier = new StatModifier(statModifier.name() + ".Offhand", statModifier.stat(), statModifier.value());
            user.addStatModifier((StatModifier)offHandModifier);
        }
        for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
            offHandModifier = new TraitModifier(traitModifier.name() + ".Offhand", traitModifier.trait(), traitModifier.value());
            user.addTraitModifier((TraitModifier)offHandModifier);
        }
        for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
            Multiplier offHandMultiplier = new Multiplier(multiplier.name() + ".Offhand", multiplier.skill(), multiplier.value());
            user.addMultiplier(offHandMultiplier);
        }
    }
}

