/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.modifier;

import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.armor.ArmorEquipEvent;
import dev.aurelium.auraskills.bukkit.util.armor.ArmorType;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.stat.StatManager;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class ArmorModifierListener
implements Listener {
    private final AuraSkills plugin;
    private final StatManager statManager;
    private final Map<UUID, Map<ArmorType, ItemStack>> storedArmor;

    public ArmorModifierListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.statManager = plugin.getStatManager();
        this.storedArmor = new HashMap<UUID, Map<ArmorType, ItemStack>>();
        if (plugin.configBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
            this.startTimer();
        }
    }

    @EventHandler
    public void onJoin(UserLoadEvent event) {
        Player player = event.getPlayer();
        BukkitUser user = BukkitUser.getUser(event.getUser());
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            SkillsItem skillsItem;
            if (armor == null) continue;
            if (this.plugin.configBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
                this.storedArmor.computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(ArmorType.matchType(armor), armor.clone());
            }
            if (armor.getType().equals((Object)Material.AIR) || !(skillsItem = new SkillsItem(armor, this.plugin)).meetsRequirements(ModifierType.ARMOR, player)) continue;
            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                user.addStatModifier(statModifier, false);
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
                user.addTraitModifier(traitModifier, false);
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                user.addMultiplier(multiplier);
            }
        }
    }

    @EventHandler
    public void onEquip(ArmorEquipEvent event) {
        ItemStack item;
        SkillsItem skillsItem;
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.configBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.plugin.getUser(player);
        if (event.getNewArmorPiece() != null && event.getNewArmorPiece().getType() != Material.AIR && (skillsItem = new SkillsItem(item = event.getNewArmorPiece(), this.plugin)).meetsRequirements(ModifierType.ARMOR, player)) {
            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                user.addStatModifier(statModifier);
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
                user.addTraitModifier(traitModifier);
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                user.addMultiplier(multiplier);
            }
        }
        if (event.getOldArmorPiece() != null && event.getOldArmorPiece().getType() != Material.AIR) {
            item = event.getOldArmorPiece();
            skillsItem = new SkillsItem(item, this.plugin);
            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                user.removeStatModifier(statModifier.name());
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
                user.removeTraitModifier(traitModifier.name());
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                user.removeMultiplier(multiplier.name());
            }
        }
    }

    private void startTimer() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    UUID uuid = player.getUniqueId();
                    Map playerStoredArmor = ArmorModifierListener.this.storedArmor.computeIfAbsent(uuid, k -> new HashMap());
                    for (ArmorType armorType : ArmorType.values()) {
                        SkillsItem skillsItem;
                        User user;
                        ItemStack stored = (ItemStack)playerStoredArmor.get((Object)armorType);
                        ItemStack wearing = player.getInventory().getItem(armorType.getEquipmentSlot());
                        boolean remove = true;
                        if (stored == null) {
                            remove = false;
                        } else if (stored.equals((Object)wearing)) continue;
                        HashSet<Stat> statsToReload = new HashSet<Stat>();
                        HashSet<Trait> traitsToReload = new HashSet<Trait>();
                        if (remove && stored.getType() != Material.AIR) {
                            user = ArmorModifierListener.this.plugin.getUser(player);
                            skillsItem = new SkillsItem(stored, ArmorModifierListener.this.plugin);
                            for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                                user.removeStatModifier(statModifier.name(), false);
                                statsToReload.add(statModifier.stat());
                            }
                            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
                                user.addTraitModifier(traitModifier, false);
                                traitsToReload.add(traitModifier.trait());
                            }
                            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                                user.removeMultiplier(multiplier.name());
                            }
                        }
                        if (wearing != null && wearing.getType() != Material.AIR) {
                            user = ArmorModifierListener.this.plugin.getUser(player);
                            skillsItem = new SkillsItem(wearing, ArmorModifierListener.this.plugin);
                            if (skillsItem.meetsRequirements(ModifierType.ARMOR, player)) {
                                for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
                                    user.addStatModifier(statModifier, false);
                                    statsToReload.add(statModifier.stat());
                                }
                                for (TraitModifier traitModifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
                                    user.addTraitModifier(traitModifier, false);
                                    traitsToReload.add(traitModifier.trait());
                                }
                                for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                                    user.addMultiplier(multiplier);
                                }
                            }
                        }
                        for (Stat stat : statsToReload) {
                            ArmorModifierListener.this.statManager.reloadStat(ArmorModifierListener.this.plugin.getUser(player), stat);
                        }
                        for (Trait trait : traitsToReload) {
                            ArmorModifierListener.this.statManager.reload(ArmorModifierListener.this.plugin.getUser(player), trait);
                        }
                        if (wearing != null) {
                            playerStoredArmor.put(armorType, wearing.clone());
                            continue;
                        }
                        playerStoredArmor.put(armorType, new ItemStack(Material.AIR));
                    }
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_ARMOR_TIMER_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        this.storedArmor.remove(event.getPlayer().getUniqueId());
    }
}

