/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.bukkit.menus.shared.SkillItem;
import dev.aurelium.auraskills.bukkit.menus.util.LevelProgressionOpener;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.builder.TemplateBuilder;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class SkillsMenu {
    private final AuraSkills plugin;

    public SkillsMenu(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void build(MenuBuilder menu) {
        menu.defaultOptions(Map.of("bar_length", 20));
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("close", globalItems::close);
        menu.fillItem(globalItems::fill);
        SkillItem skillItem = new SkillItem(this.plugin);
        skillItem.buildComponents(menu);
        menu.item("your_skills", item -> item.replace("player", p -> p.player().getName()));
        menu.item("stats", item -> {
            item.onClick(c -> this.plugin.getSlate().openMenu(c.player(), "stats", Map.of("previous_menu", "skills")));
            item.modify(i -> {
                ItemMeta patt1667$temp = i.item().getItemMeta();
                if (patt1667$temp instanceof SkullMeta) {
                    SkullMeta meta = (SkullMeta)patt1667$temp;
                    meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)i.player().getUniqueId()));
                    i.item().setItemMeta((ItemMeta)meta);
                }
                return i.item();
            });
        });
        menu.template("skill", Skill.class, template -> {
            skillItem.baseSkillItem((TemplateBuilder<Skill>)template);
            template.onClick(c -> {
                User user = this.plugin.getUser(c.player());
                if (user.hasSkillPermission((Skill)c.value())) {
                    new LevelProgressionOpener(this.plugin).open(c.player(), (Skill)c.value());
                }
            });
            template.definedContexts(m -> {
                for (Skill context : this.plugin.getSkillManager().getEnabledSkills()) {
                    if (!(context instanceof CustomSkill)) continue;
                    CustomSkill skill = (CustomSkill)context;
                    try {
                        ConfigurateItemParser parser = new ConfigurateItemParser(this.plugin);
                        ConfigurationNode config = parser.parseItemContext(skill.getDefined().getItem());
                        PositionProvider provider = parser.parsePositionProvider(config, m.menu(), "skill");
                        if (provider == null) continue;
                        m.menu().setPositionProvider("skill", context, provider);
                    }
                    catch (SerializationException e) {
                        this.plugin.logger().warn("Error parsing ItemContext of CustomSkill " + skill.getId());
                        e.printStackTrace();
                    }
                }
                return new HashSet<Skill>(this.plugin.getSkillManager().getEnabledSkills());
            });
        });
    }
}

