/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.api.implementation.ApiMenuManager;
import dev.aurelium.auraskills.bukkit.menus.AbilitiesMenu;
import dev.aurelium.auraskills.bukkit.menus.LeaderboardMenu;
import dev.aurelium.auraskills.bukkit.menus.LevelProgressionMenu;
import dev.aurelium.auraskills.bukkit.menus.SkillsMenu;
import dev.aurelium.auraskills.bukkit.menus.SourcesMenu;
import dev.aurelium.auraskills.bukkit.menus.StatsMenu;
import dev.aurelium.auraskills.bukkit.menus.contexts.AbilityContext;
import dev.aurelium.auraskills.bukkit.menus.contexts.ManaAbilityContext;
import dev.aurelium.auraskills.bukkit.menus.contexts.SkillContext;
import dev.aurelium.auraskills.bukkit.menus.contexts.SortTypeContext;
import dev.aurelium.auraskills.bukkit.menus.contexts.StatContext;
import dev.aurelium.auraskills.bukkit.menus.contexts.XpSourceContext;
import dev.aurelium.auraskills.bukkit.menus.util.PlaceholderHelper;
import dev.aurelium.auraskills.common.util.text.Replacer;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.context.ContextManager;
import java.util.function.Consumer;

public class MenuRegistrar {
    private final AuraSkills plugin;
    private final Slate slate;
    private final PlaceholderHelper placeholderHelper;

    public MenuRegistrar(AuraSkills plugin) {
        this.plugin = plugin;
        this.slate = plugin.getSlate();
        this.placeholderHelper = new PlaceholderHelper(plugin);
    }

    public void register() {
        ContextManager cm = this.slate.getContextManager();
        cm.registerContext("Skill", new SkillContext(this.plugin));
        cm.registerContext("Stat", new StatContext(this.plugin));
        cm.registerContext("Source", new XpSourceContext(this.plugin));
        cm.registerContext("SortType", new SortTypeContext());
        cm.registerContext("Ability", new AbilityContext(this.plugin));
        cm.registerContext("ManaAbility", new ManaAbilityContext(this.plugin));
        this.buildMenus();
    }

    private void buildMenus() {
        this.slate.setGlobalBehavior(behavior -> {
            behavior.replacer(c -> this.placeholderHelper.replaceMenuMessage(c.placeholder(), null, c.player(), c.menu(), new Replacer()));
            behavior.localeProvider(this.plugin::getLocale);
        });
        this.buildMenu("skills", menu -> new SkillsMenu(this.plugin).build((MenuBuilder)menu));
        this.buildMenu("stats", menu -> new StatsMenu(this.plugin).build((MenuBuilder)menu));
        this.buildMenu("level_progression", menu -> new LevelProgressionMenu(this.plugin).build((MenuBuilder)menu));
        this.buildMenu("leaderboard", menu -> new LeaderboardMenu(this.plugin).build((MenuBuilder)menu));
        this.buildMenu("sources", menu -> new SourcesMenu(this.plugin).build((MenuBuilder)menu));
        this.buildMenu("abilities", menu -> new AbilitiesMenu(this.plugin).build((MenuBuilder)menu));
        for (String nonDefault : ((ApiMenuManager)this.plugin.getApiBukkit().getMenuManager()).getNonDefaultMenuNames()) {
            this.buildMenu(nonDefault, menu -> {});
        }
    }

    private void buildMenu(String name, Consumer<MenuBuilder> builder) {
        this.slate.buildMenu(name, menu -> {
            builder.accept((MenuBuilder)menu);
            ((ApiMenuManager)this.plugin.getApiBukkit().getMenuManager()).applyBuilders(name, (MenuBuilder)menu);
        });
    }
}

