/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.ItemRegistryMenuProvider;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.slate.function.ItemMetaParser;
import dev.aurelium.auraskills.slate.option.SlateOptions;
import dev.aurelium.auraskills.slate.option.SlateOptionsBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class MenuOptions {
    private final AuraSkills plugin;

    public MenuOptions(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public SlateOptions getBaseOptions() {
        return new SlateOptionsBuilder().keyedItemProvider(new ItemRegistryMenuProvider(this.plugin.getItemRegistry())).mainDirectory(new File(this.plugin.getDataFolder(), "menus")).loreWrappingWidth(this.plugin.configInt(Option.MENUS_LORE_WRAPPING_WIDTH)).itemMetaParsers(this.getMetaParsers()).build();
    }

    public Map<String, ItemMetaParser> getMetaParsers() {
        HashMap<String, ItemMetaParser> parsers = new HashMap<String, ItemMetaParser>();
        parsers.put("potion_data", (item, config) -> {
            new ConfigurateItemParser(this.plugin).parsePotionData(item, config);
            return item;
        });
        parsers.put("nbt", (item, config) -> new ConfigurateItemParser(this.plugin).parseNBT(item, config));
        parsers.put("hide_tooltip", (item, config) -> {
            new ConfigurateItemParser(this.plugin).parseHideTooltip(config, item);
            return item;
        });
        return parsers;
    }
}

