/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.common.leaderboard.LeaderboardManager;
import dev.aurelium.auraskills.common.leaderboard.SkillValue;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class LeaderboardMenu {
    private final AuraSkills plugin;

    public LeaderboardMenu(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void build(MenuBuilder menu) {
        menu.replaceTitle("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
        menu.properties(m -> Map.of("skill", m.menu().getProperty("skill", Skills.FARMING), "previous_menu", "level_progression"));
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("back", globalItems::backToLevelProgression);
        menu.fillItem(globalItems::fill);
        menu.template("leaderboard_player", Integer.class, template -> {
            LeaderboardManager lb = this.plugin.getLeaderboardManager();
            template.replace("place", p -> String.valueOf(p.value()));
            template.replace("player", p -> {
                SkillValue value = lb.getSkillValue((Skill)p.menu().getProperty("skill"), (Integer)p.value());
                String name = Bukkit.getOfflinePlayer((UUID)(value != null ? value.id() : UUID.randomUUID())).getName();
                return name != null ? name : "?";
            });
            template.replace("level", p -> {
                SkillValue value = lb.getSkillValue((Skill)p.menu().getProperty("skill"), (Integer)p.value());
                return String.valueOf(value != null ? value.level() : 0);
            });
            template.definedContexts(m -> IntStream.rangeClosed(1, 10).boxed().collect(Collectors.toSet()));
            template.modify(t -> {
                Skill skill = (Skill)t.menu().getProperty("skill");
                SkillValue value = lb.getSkillValue(skill, (Integer)t.value());
                if (value == null) {
                    return null;
                }
                ItemMeta patt2524$temp = t.item().getItemMeta();
                if (patt2524$temp instanceof SkullMeta) {
                    SkullMeta meta = (SkullMeta)patt2524$temp;
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)value.id());
                    if (offlinePlayer.getName() != null) {
                        meta.setOwningPlayer(offlinePlayer);
                        t.item().setItemMeta((ItemMeta)meta);
                    }
                }
                return t.item();
            });
        });
    }
}

