/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.mana;

import dev.aurelium.auraskills.api.event.mana.ManaAbilityRefreshEvent;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TimerCountdown {
    private final AuraSkills plugin;

    public TimerCountdown(AuraSkills plugin) {
        this.plugin = plugin;
        this.startCountdown();
    }

    public void startCountdown() {
        this.plugin.getScheduler().timerSync(new TaskRunnable(){

            @Override
            public void run() {
                TimerCountdown.this.countCooldown();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        this.plugin.getScheduler().timerSync(new TaskRunnable(){

            @Override
            public void run() {
                TimerCountdown.this.countErrorTimer();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void countCooldown() {
        for (User user : this.plugin.getUserManager().getOnlineUsers()) {
            for (ManaAbilityData data : user.getManaAbilityDataMap().values()) {
                int cooldown = data.getCooldown();
                if (cooldown >= 2) {
                    data.setCooldown(cooldown - 2);
                    this.callRefreshEvent(user, data.getManaAbility());
                    continue;
                }
                if (cooldown != 1) continue;
                data.setCooldown(0);
                this.callRefreshEvent(user, data.getManaAbility());
            }
        }
    }

    private void countErrorTimer() {
        for (User user : this.plugin.getUserManager().getOnlineUsers()) {
            for (ManaAbilityData data : user.getManaAbilityDataMap().values()) {
                int errorTimer = data.getErrorTimer();
                if (errorTimer <= 0) continue;
                data.setErrorTimer(errorTimer - 1);
            }
        }
    }

    private void callRefreshEvent(User user, ManaAbility manaAbility) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player != null) {
            ManaAbilityRefreshEvent event = new ManaAbilityRefreshEvent(player, user.toApi(), manaAbility);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }
}

