/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.mana;

import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ManaAbilityProvider;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ReadiedManaAbility
extends ManaAbilityProvider {
    private final String[] materials;
    private final Action[] actions;

    public ReadiedManaAbility(AuraSkills plugin, ManaAbility manaAbility, ManaAbilityMessage activateMessage, @Nullable ManaAbilityMessage stopMessage, String[] materials, Action[] actions) {
        super(plugin, manaAbility, activateMessage, stopMessage);
        this.materials = materials;
        this.actions = actions;
    }

    @Override
    protected boolean isReady(User user) {
        ManaAbilityData data = user.getManaAbilityData(this.manaAbility);
        return data.isReady() && !data.isActivated();
    }

    protected boolean isHoldingMaterial(Player player) {
        return this.materialMatches(player.getInventory().getItemInMainHand().getType().toString());
    }

    protected boolean materialMatches(String checked) {
        for (String material : this.materials) {
            if (!checked.contains(material)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedBlock(Block block) {
        return this.hasInteraction(block);
    }

    protected boolean hasInteraction(Block block) {
        Material mat = block.getType();
        return switch (mat) {
            case Material.ENDER_CHEST, Material.CRAFTING_TABLE, Material.ENCHANTING_TABLE, Material.BEACON, Material.ANVIL, Material.GRINDSTONE, Material.CARTOGRAPHY_TABLE, Material.LOOM, Material.STONECUTTER, Material.SMITHING_TABLE, Material.LEVER, Material.BAMBOO_BUTTON, Material.BIRCH_BUTTON, Material.ACACIA_BUTTON, Material.CHERRY_BUTTON, Material.CRIMSON_BUTTON, Material.DARK_OAK_BUTTON, Material.JUNGLE_BUTTON, Material.MANGROVE_BUTTON, Material.OAK_BUTTON, Material.POLISHED_BLACKSTONE_BUTTON, Material.SPRUCE_BUTTON, Material.STONE_BUTTON, Material.WARPED_BUTTON -> true;
            default -> {
                BlockData data = block.getBlockData();
                if (block.getState() instanceof InventoryHolder) {
                    yield true;
                }
                if (data instanceof Bed || data instanceof Sign || data instanceof Door || data instanceof Gate || data instanceof NoteBlock || data instanceof TrapDoor) {
                    yield true;
                }
                yield false;
            }
        };
    }

    public String[] getMaterials() {
        return this.materials;
    }

    @EventHandler
    public void onReady(PlayerInteractEvent event) {
        if (this.isDisabled()) {
            return;
        }
        boolean valid = false;
        for (Action action : this.actions) {
            if (event.getAction() != action) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (!this.isHoldingMaterial(player)) {
            return;
        }
        if (block != null && this.isExcludedBlock(block)) {
            return;
        }
        if (!this.isAllowReady(player, event)) {
            return;
        }
        User user = this.plugin.getUser(player);
        ManaAbilityData data = user.getManaAbilityData(this.manaAbility);
        Locale locale = user.getLocale();
        if (user.getManaAbilityLevel(this.manaAbility) <= 0) {
            return;
        }
        if (data.isActivated()) {
            return;
        }
        if (data.isReady()) {
            return;
        }
        if (data.getCooldown() == 0) {
            data.setReady(true);
            this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(ManaAbilityMessage.valueOf(this.manaAbility.name() + "_RAISE"), locale));
            this.scheduleUnready(player, locale, data);
        } else if (data.getErrorTimer() == 0) {
            this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(ManaAbilityMessage.NOT_READY, locale).replace("{cooldown}", NumberUtil.format0((double)data.getCooldown() / 20.0)));
            data.setErrorTimer(2);
        }
    }

    private void scheduleUnready(Player player, Locale locale, ManaAbilityData data) {
        int READY_DURATION = 80;
        this.plugin.getScheduler().scheduleSync(() -> {
            if (!data.isActivated() && data.isReady()) {
                data.setReady(false);
                this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(ManaAbilityMessage.valueOf(this.manaAbility.name() + "_LOWER"), locale));
            }
        }, READY_DURATION * 50, TimeUnit.MILLISECONDS);
    }

    private boolean isAllowReady(Player player, PlayerInteractEvent event) {
        if (this.manaAbility.optionBoolean("require_sneak", false) && !player.isSneaking()) {
            return false;
        }
        if (this.isBlockPlace(event, player, this.manaAbility)) {
            return false;
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return false;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.shouldIgnoreItem(item)) {
            return false;
        }
        User user = this.plugin.getUser(player);
        return user.hasSkillPermission(this.manaAbility.getSkill());
    }

    private boolean isBlockPlace(PlayerInteractEvent event, Player player, ManaAbility manaAbility) {
        if (manaAbility.optionBoolean("check_offhand", true) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (player.isSneaking() && manaAbility.optionBoolean("sneak_offhand_bypass", true)) {
                return false;
            }
            ItemStack item = player.getInventory().getItemInOffHand();
            if (item.getType() == Material.AIR) {
                return false;
            }
            return item.getType().isBlock();
        }
        return false;
    }
}

