/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.parser;

import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.loot.LootParsingContext;
import dev.aurelium.auraskills.api.loot.LootValues;
import dev.aurelium.auraskills.bukkit.loot.LootManager;
import dev.aurelium.auraskills.bukkit.loot.context.ContextProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class LootParsingContextImpl
implements LootParsingContext {
    private final LootManager manager;

    public LootParsingContextImpl(LootManager manager) {
        this.manager = manager;
    }

    @Override
    public LootValues parseValues(ConfigurationNode config) {
        int weight = config.node("weight").getInt(10);
        String message = config.node("message").getString("");
        return new LootValues(weight, message, this.parseContexts(config), this.parseOptions(config));
    }

    public Map<String, Set<LootContext>> parseContexts(ConfigurationNode config) {
        HashMap<String, Set<LootContext>> contexts = new HashMap<String, Set<LootContext>>();
        for (String contextKey : this.manager.getContextKeySet()) {
            Set<LootContext> lootContext;
            ContextProvider contextProvider;
            if (config.node(contextKey).virtual() || (contextProvider = this.manager.getContextProvider(contextKey)) == null) continue;
            try {
                lootContext = contextProvider.parseContext(config);
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
            if (lootContext == null) continue;
            contexts.put(contextKey, lootContext);
        }
        return contexts;
    }

    public Map<String, Object> parseOptions(ConfigurationNode config) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (String optionKey : this.manager.getLootOptionKeys()) {
            if (config.node(optionKey).virtual()) continue;
            Object option = config.node(optionKey).raw();
            options.put(optionKey, option);
        }
        return options;
    }
}

