/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.parser;

import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.api.loot.LootParsingContext;
import dev.aurelium.auraskills.bukkit.loot.LootManager;
import dev.aurelium.auraskills.bukkit.loot.item.ItemSupplier;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LootEnchantEntry;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LootEnchantList;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LootEnchantments;
import dev.aurelium.auraskills.bukkit.loot.parser.CustomItemParser;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.util.data.Validate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ItemLootParser
implements LootParser {
    private final LootManager manager;
    private final ConfigurateItemParser itemParser;

    public ItemLootParser(LootManager manager) {
        this.manager = manager;
        this.itemParser = new ConfigurateItemParser(manager.getPlugin());
    }

    @Override
    public Loot parse(LootParsingContext context, ConfigurationNode config) throws SerializationException {
        ItemSupplier item = null;
        for (CustomItemParser parser : this.manager.getCustomItemParsers()) {
            if (!parser.shouldUseParser(config)) continue;
            item = new ItemSupplier(parser.parseCustomItem(config), null);
            break;
        }
        if (item == null) {
            item = this.parseItem(config);
        }
        Validate.notNull(item, "Failed to parse item");
        int[] amounts = this.parseAmount(config);
        return new ItemLoot(context.parseValues(config), item, amounts[0], amounts[1]);
    }

    private ItemSupplier parseItem(ConfigurationNode config) throws SerializationException {
        List<String> excludedKeys = List.of("amount", "enchantments");
        ItemStack baseItem = this.itemParser.parseItem(config, excludedKeys);
        Map<LootEnchantList, Integer> possibleEnchants = this.parsePossibleEnchants(config);
        return new ItemSupplier(baseItem, new LootEnchantments(possibleEnchants));
    }

    private Map<LootEnchantList, Integer> parsePossibleEnchants(ConfigurationNode config) throws SerializationException {
        HashMap<LootEnchantList, Integer> possibleEnchants = new HashMap<LootEnchantList, Integer>();
        if (config.hasChild("enchantments")) {
            LootEnchantList singleList = this.parseSingleEnchantList(config);
            possibleEnchants.put(singleList, 1);
        }
        return possibleEnchants;
    }

    private LootEnchantList parseSingleEnchantList(ConfigurationNode config) throws SerializationException {
        ArrayList<LootEnchantEntry> entryList = new ArrayList<LootEnchantEntry>();
        List<String> enchantmentStrings = config.node("enchantments").getList(String.class, new ArrayList());
        for (String enchantmentEntry : enchantmentStrings) {
            String[] splitEntry = enchantmentEntry.split(" ");
            String enchantmentName = splitEntry[0].toLowerCase(Locale.ROOT);
            int minLevel = 1;
            int maxLevel = 1;
            if (splitEntry.length > 1) {
                String levelString = splitEntry[1];
                if (levelString.contains("-")) {
                    String[] splitLevel = levelString.split("-");
                    minLevel = Integer.parseInt(splitLevel[0]);
                    maxLevel = Integer.parseInt(splitLevel[1]);
                } else {
                    int fixedLevel;
                    minLevel = fixedLevel = Integer.parseInt(splitEntry[1]);
                    maxLevel = fixedLevel;
                }
            }
            LootEnchantEntry entry = new LootEnchantEntry(enchantmentName, minLevel, maxLevel);
            entryList.add(entry);
        }
        return new LootEnchantList(entryList);
    }

    protected int[] parseAmount(ConfigurationNode config) {
        if (config.hasChild("amount")) {
            Object object = config.node("amount").raw();
            if (object instanceof Integer) {
                Integer amount = (Integer)object;
                return new int[]{amount, amount};
            }
            if (object instanceof String) {
                int minAmount;
                String amountString = (String)object;
                String[] splitString = amountString.split("-");
                int maxAmount = minAmount = Integer.parseInt(splitString[0]);
                if (splitString.length > 1) {
                    maxAmount = Integer.parseInt(splitString[1]);
                }
                return new int[]{minAmount, maxAmount};
            }
        }
        return new int[]{1, 1};
    }
}

